// Copyright 2001 FreeHEP.
package org.freehep.graphicsio.font.encoding;

import java.io.*;
import java.util.StringTokenizer;
import java.lang.Exception;

/**
 * CharTableConverter class generates java files from
 * given unicode formatted txt file to use with Lookup class.
 * Usage java CharTableConverter encoding.unicode.txt [encoding type]
 *
 * @author Sami Kama
 * @version $Id: CharTableConverter.java,v 1.1.1.1 2004/05/31 05:08:52 kuromaru Exp $
 */
public class CharTableConverter {
	private BufferedReader textFile = null;
	private PrintWriter javaOut = null;
	private String outName = null;
	private int encType=1;
	private String ENC="";

	public void putHeaders() throws Exception{

		javaOut.println("//Generated by CharTableConverter");
		javaOut.println("//!!DO NOT EDIT");
		javaOut.println("package org.freehep.graphicsio.font.encoding;");
		javaOut.println();
		javaOut.println("import java.util.*;");
		javaOut.println();
		javaOut.println("/**");
		javaOut.println(" * Generated "+ENC+" "+outName+" Encoding Table.");
		javaOut.println(" *");
		javaOut.println(" * @author org.freehep.graphicsio.font.encoding.CharTableConverter");
		javaOut.println(" * @version $Id: CharTableConverter.java,v 1.1.1.1 2004/05/31 05:08:52 kuromaru Exp $");		
		javaOut.println(" */");
		javaOut.println("public class "+ENC+outName+" extends AbstractCharTable {");
		javaOut.println("\tprivate Hashtable unicodeToName = new Hashtable();");
		javaOut.println("\tprivate Hashtable nameToUnicode = new Hashtable();");
		javaOut.println("\tprivate Hashtable nameToEnc = new Hashtable();");
		javaOut.println("\tprivate String[] encToName = new String[256];");
		javaOut.println("\tpublic "+ENC+outName+"(){");
	}

	public void putMethods() throws Exception{

	        /*
	        javaOut.println("\tpublic String toName(char c){");
		javaOut.println("\t\treturn((String)(unicodeToName.get(new Character(c))));");
		javaOut.println("\t}");
		javaOut.println();
                */
		javaOut.println("\tpublic String toName(Character c){");
		javaOut.println("\t\treturn((String)unicodeToName.get(c));");
		javaOut.println("\t}");
		javaOut.println();
		javaOut.println("\tpublic String toName(int enc){");
		javaOut.println("\t\tif(enc!=0)");
		javaOut.println("\t\treturn(encToName[enc]);");
		javaOut.println("\t\treturn(null);");
		javaOut.println("\t}");
		javaOut.println();
		/*
		javaOut.println("\tpublic String toName(Integer enc){");
		javaOut.println("\t\treturn(encToName[enc.intValue()]);");
		javaOut.println("\t}");
		javaOut.println();
		*/
		javaOut.println("\tpublic int toEncoding(String name){");
		javaOut.println("\t\treturn(((Integer)(nameToEnc.get(name))).intValue());");
		javaOut.println("\t}");
		javaOut.println();
		javaOut.println("\tpublic char toUnicode(String name){");
		javaOut.println("\t\treturn(((Character)(nameToUnicode.get(name))).charValue());");
		javaOut.println("\t}");
		javaOut.println();
		javaOut.println("\tpublic String getName(){");
		javaOut.println("\treturn(\""+outName+"\");");
		javaOut.println("\t}");
		javaOut.println();
		javaOut.println("\tpublic String getEncoding(){");
		javaOut.println("\t	return(\""+ENC+"\");");
		javaOut.println("\t}");
		javaOut.println();
		javaOut.println("}");
		javaOut.flush();
		javaOut.close();
	}

	public void openFiles(String txtName, String enc) throws Exception{
		InputStream textIn = new FileInputStream(txtName);
		Reader textFileReader = new InputStreamReader(textIn,"UTF-16");
		ENC=enc;
		outName=txtName.substring(0,(txtName.indexOf(".")));
		outName=(outName.substring(0,1)).toUpperCase()+outName.substring(1);

		Writer javaFileWriter = new FileWriter(ENC+outName+".java");
		textFile = new BufferedReader(textFileReader);
		javaOut = new PrintWriter(javaFileWriter);
	}

	public void convertTxtToHash() throws Exception{
		String buff = new String();
		String charCode = new String();
		String charName = new String();
		String encoding = new String();
		String hexformat = new String();

		if (ENC.equals("ISO")) encType=5;
		if (ENC.equals("PDF")) encType=4;
		if (ENC.equals("WIN")) encType=3;
		if (ENC.equals("MAC")) encType=2;
		if (ENC.equals("STD")) encType=1;


		while((buff=textFile.readLine())!=null){

			StringTokenizer st = new StringTokenizer(buff,"\u0009\u0020");

			if (!st.hasMoreTokens()) continue;
			charCode=st.nextToken();
			if (charCode.equals("##")) continue;

			if (!st.hasMoreTokens()) continue;
			charName=st.nextToken();

			for (int i=0;i<encType;i++){
				if (!st.hasMoreTokens()) continue;
				encoding = st.nextToken();
			}

				if (charCode.startsWith("\\u")){
				int cCL = charCode.length();
				javaOut.println();
				hexformat = charCode.substring(cCL-4,cCL);
				javaOut.print("\t\t\t");
				javaOut.println("unicodeToName.put(new Character((char)0x"+
					hexformat+"),\""+charName+"\");");

				javaOut.print("\t\t\t");
				javaOut.println("nameToUnicode.put(\""
					+charName+"\""+", new Character((char)0x"+hexformat+"));");

			} else {
				hexformat = "00"+(Integer.toHexString((int)charCode.charAt(0)));
				javaOut.println();
				javaOut.print("\t\t\t");
				javaOut.println("unicodeToName.put(new Character((char)0x"+
					hexformat.substring(hexformat.length()-4,hexformat.length())+
					"),\""+charName+"\");");

				javaOut.print("\t\t\t");
				javaOut.println("nameToUnicode.put(\""+
						charName+"\""+",new Character((char)0x"+
					hexformat.substring(hexformat.length()-4,hexformat.length())+
						"));");

				
			}

			Integer encodingInt = Integer.decode(encoding);
			if (encodingInt.intValue() >= 0) {
				    
			    javaOut.print("\t\t\t");
			    javaOut.println("nameToEnc.put(\""+charName+
					    "\", new Integer("+encodingInt+"));");
			    
			    javaOut.print("\t\t\t");
			    javaOut.println("encToName["+encodingInt+"]=\""+charName+"\";");
			}
			
		}


 		javaOut.println();
		javaOut.println("\t\t}");
		javaOut.println();

	}


	public static void main(String args[]) throws Exception{

		if ((args.length<1)||(args.length>2)){
			System.err.println("Usage: CharTableConverter txtfile [Encoding type]");
			System.exit(0);
		}
		CharTableConverter ht = new CharTableConverter();
		if (args.length==2){
			try {
				ht.openFiles(args[0] ,args[1]);
			} catch (IOException e) {
				System.err.println(e.getMessage());
			}
		}

		if (args.length==1){
			try {
				ht.openFiles(args[0] ,"");
			} catch (IOException e) {
				System.err.println(e.getMessage());
			}
		}
		try {
			ht.putHeaders();
		} catch (IOException e) {
			System.err.println(e.getMessage());
		}

		try {
			ht.convertTxtToHash();
		} catch (IOException e) {
			System.err.println(e.getMessage());
		}

		try {
			ht.putMethods();
		} catch (IOException e) {
			System.err.println(e.getMessage());
		}

	}

}
