/*
 * 쐬F 2004/11/25
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;


/**
 * @author kuromaru
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class SGFileChooser extends JFileChooser
{

	/**
	 * 
	 */
	public static final String TITLE = "Overwrite Confirmation";
	
	
	/**
	 * 
	 */
	public static final String MSG_CONFIRM_OVERWRITE
		= "The file you have selected already exists.\n" + "Overwrite it?";

	
	
	/**
	 * 
	 *
	 */
	public SGFileChooser()
	{
		super();
	}
	

	/**
	 * 
	 * @param currentDirectory
	 */
	public SGFileChooser( File currentDirectory )
	{
		super( currentDirectory );
	}
	
	
	/**
	 * 
	 * @param currentDirectoryPath
	 */
	public SGFileChooser( String currentDirectoryPath )
	{
		super( currentDirectoryPath );
	}

	
	
	/**
	 * Override to show confirmation dialog whene the file already exists. 
	 */
	public void approveSelection()
	{
		if( this.getSelectedFile()!=null )
		{
			// if selected file already exists
			if( this.getSelectedFile().exists()
				&& this.getDialogType()==JFileChooser.SAVE_DIALOG )
			{
				int ret = JOptionPane.showConfirmDialog(
					this,
					MSG_CONFIRM_OVERWRITE,
					TITLE,
					JOptionPane.YES_NO_OPTION
				);
		        if( ret == JOptionPane.YES_OPTION )
		        {
		        	super.approveSelection();
		        }
			}
	        else
	        {
	        	super.approveSelection();
	        }
		}
	}



	/**
	 * Override not to select directories.
	 */
	public void setSelectedFile( File f )
	{
		if( f!=null && f.isDirectory() )
		{
			return;
		}
		super.setSelectedFile(f);
	}


}
