/*
 * Created on 2004/10/18
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.JWindow;


public class SGSplashWindow extends JWindow
{

	/**
	 * 
	 */
	private Image mImage;


	/**
	 * 
	 */
	private Dimension mImageSize = new Dimension();


	/**
	 * 
	 * @param win
	 */
	public SGSplashWindow( Image img )
	{

		if( img==null )
		{
			throw new NullPointerException("img==null");
		}


		// set the media tracker
		MediaTracker mt = new MediaTracker(this);
		mt.addImage( img, 0 );
		try
		{
			mt.waitForAll();
		}
		catch (InterruptedException ex)
		{
		}


		// set attributes
		this.mImage = img;
		mImageSize.width = mImage.getWidth(this);
		mImageSize.height = mImage.getHeight(this);


		// set the bounds of this window
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		this.setBounds(
			( screen.width - mImageSize.width )/2,
			( screen.height - mImageSize.height )/2,
			mImageSize.width,
			mImageSize.height
		);


	}


	/**
	 * 
	 */	
	public void paint( Graphics g )
	{
		g.drawImage(
			mImage, 0, 0, 
			mImageSize.width, mImageSize.height,
			this
		);
	}


}

