/*
 * 쐬: 2004/06/29
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;


/**
 * @author kuromaru
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public abstract class SGFileChooserWizardDialog extends SGWizardDialog
{

	/**
	 * File chooser dialog.
	 */
	protected JFileChooser mFileChooser = new SGFileChooser();


	/**
	 * 
	 */
	public SGFileChooserWizardDialog()
	{
		super();
	}


	/** Creates new form SGFileChooserWizardDialog */
	public SGFileChooserWizardDialog(java.awt.Frame parent, boolean modal)
	{
		super(parent, modal);
	}

	
	/**
	 * Sets the current file filter to the attribute.
	 * @param ff
	 */
	public void setFileFilter( FileFilter ff )
	{
		this.mFileChooser.setFileFilter(ff);
	}

	 
	 
	/**
	 * Temporary path name.
	 */
	private String mTemporaryPath = null;
	 
	 

	/**
	 * Open the file chooser dialog.
	 * @return List of selected files.
	 */
	protected ArrayList openFileChooser()
	{

		// set the path
		String path = this.mTemporaryPath!=null ? this.mTemporaryPath : PATH_NAME;
		this.mFileChooser.setCurrentDirectory( new File( path ) );

		
		// show open dialog
		int ret = this.mFileChooser.showOpenDialog(this);

		
		// get selected files
		ArrayList fileList = new ArrayList();
		switch( ret )
		{
			// selected
			case JFileChooser.APPROVE_OPTION :
			{
				if( this.mFileChooser.isMultiSelectionEnabled() )
				{
					File[] files = this.mFileChooser.getSelectedFiles();
					for( int ii=0; ii<files.length; ii++ )
					{
						fileList.add( files[ii] );
					}
				}
				else
				{
					fileList.add( this.mFileChooser.getSelectedFile() );
				}
				break;
			}

			// canceled
			case JFileChooser.CANCEL_OPTION :
			{
				break;
			}

			// error
			case JFileChooser.ERROR_OPTION :
			{
				return null;
			}

			default :
			{
				
			}
		}

		
		// record the current path
		this.mTemporaryPath = this.mFileChooser.getCurrentDirectory().getPath();
		
		return fileList;

	}



}
