/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupString
extends SGElementGroupSXY
implements SGIStringConstants,
SGIElementGroupConstants {
    protected String mFontName;
    protected float mFontSize;
    protected int mFontStyle;
    protected float mAngle;

    public boolean setFont(String string, int n, float f) {
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                sGDrawingElementString.setFont(string, n, f);
            }
        }
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                sGDrawingElementString.setAngle(f);
            }
        }
        return true;
    }

    public String getFontName() {
        return this.mFontName;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)this.mDrawingElementArray[i];
                sGDrawingElementString2DExtended.drawString(graphics2D);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D();
        sGDrawingElementString2D.setVisible(this.mVisibleFlag);
        sGDrawingElementString2D.setFont(this.mFontName, this.mFontStyle, this.mFontSize);
        sGDrawingElementString2D.setAngle(this.mAngle);
        sGDrawingElementString2D.setColorList(this.mColorList);
        return sGDrawingElementString2D;
    }

    protected boolean initDrawingElement(int n) {
        SGDrawingElementString2DExtended[] sGDrawingElementString2DExtendedArray = new SGDrawingElementString2DExtended[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementString2DExtendedArray[i] = new SGDrawingElementString2DExtended();
        }
        this.mDrawingElementArray = sGDrawingElementString2DExtendedArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (sGTuple2fArray == null) {
            throw new IllegalArgumentException("pointArray==null");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new Error("pointArray.length != this.mDrawingElementArray.length");
        }
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementString2DExtended.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementString2DExtended.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
            sGDrawingElementString.setFont(this.mFontName, this.mFontStyle, this.mFontSize);
            sGDrawingElementString.setAngle(this.mAngle);
            sGDrawingElementString.setColorList(this.mColorList);
            sGDrawingElementString.setMagnification(this.mMagnification);
        }
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementString)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)sGDrawingElement;
        this.setFont(sGDrawingElementString.getFontName(), sGDrawingElementString.getFontStyle(), sGDrawingElementString.getFontSize());
        this.setAngle(sGDrawingElementString.getAngle());
        return true;
    }

    public String getTagName() {
        return "Label";
    }

    public boolean writeProperty(Element element) {
        String string = "pt";
        String string2 = "\u00b0";
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("FontSize", Float.toString(this.mFontSize) + string);
        element.setAttribute("FontName", this.mFontName);
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mFontStyle));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        element.setAttribute("Angle", Float.toString(-this.mAngle / ((float)Math.PI / 180)) + string2);
        return true;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        this.getProperties(stringProperties);
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setFontName(this.getFontName());
        stringProperties.setFontSize(this.getFontSize());
        stringProperties.setFontStyle(this.getFontStyle());
        stringProperties.setAngle(this.getAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        Float f = stringProperties.getFontSize();
        if (f == null) {
            return false;
        }
        Integer n = stringProperties.getFontStyle();
        if (n == null) {
            return false;
        }
        this.setFont(stringProperties.getFontName(), n, f.floatValue());
        Float f2 = stringProperties.getAngle();
        if (f2 == null) {
            return false;
        }
        this.setAngle(f2.floatValue());
        return true;
    }

    public static class StringProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"FontSize", "FontStyle", "FontName", "Angle"};

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(stringProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getFontSize() {
            String string = this.getProperty("FontSize");
            return SGUtilityText.getFloat(string);
        }

        public Integer getFontStyle() {
            String string = this.getProperty("FontStyle");
            return SGUtilityText.getInteger(string);
        }

        public String getFontName() {
            return this.getProperty("FontName");
        }

        public Float getAngle() {
            String string = this.getProperty("Angle");
            return SGUtilityText.getFloat(string);
        }

        public boolean setFontSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("FontSize", new Float(f).toString());
            return true;
        }

        public boolean setFontStyle(int n) {
            this.setProperty("FontStyle", new Integer(n).toString());
            return true;
        }

        public boolean setFontName(String string) {
            if (string == null) {
                return false;
            }
            this.setProperty("FontName", new String(string));
            return true;
        }

        public boolean setAngle(float f) {
            this.setProperty("Angle", new Float(f).toString());
            return true;
        }
    }
}

