/*
 * samma
 * msg_convert.h
 *
 */
#ifndef _MSG_CONVERT_H
#define _MSG_CONVERT_H

#include "harmless.h"

/**
 * error messages
 */
#define CONV_ERR_MEM "Cannot allocate memory(msg_convert)"
#define CONV_ERR_READ "Cannot read a config file: %s"
#define CONV_ERR_OPEN "Cannot open a config file: %s :%s"
#define CONV_ERR_TOOLONGLINE    "%s (line: %d) too long line"
#define CONV_ERR_FEW_ITEM    "%s (line: %d) needs more column"
#define CONV_ERR_WITH_LINE "%s (line: %d) ERR:(%s)"
#define CONV_ERR_WRONG_FUNC "%s (line: %d) wrong command(%s)"
#define CONV_ERR_EXEC_EXT "Failed to execute external command.: command=%s, source=%s, message-id=%s, sender=%s, recipients=%s"
#define CONV_ERR_EXEC_IN "Failed to execute internal command.: command=%s, source=%s, message-id=%s, sender=%s, recipients=%s"

/**
 * type def
 */
#define MSG_CONV_OK		1;
#define MSG_CONV_NG		0;

enum {
    FUNCTION,
    COMMAND,
};


// config構造体にセットするもの
typedef struct command_list {
    char *mime_before;
    char *mime_after;
    char *file_extension;

    char *command_name;		/* 関数もしくはコマンド名 */
    int command_type;	/* 指定されたコマンドが外部コマンドかどうか */
    int (*in_func)();	/* 内部コマンド（関数） */
    char **arg_list;	/* 外部コマンドとオプションのリスト(NULL終端が必須) */

    struct command_list *next;
} command_list_t;



/**
 * functions
 */
int msg_convert(GMimeObject *, GMimeObject **, harmless_proc_arg_t *);

char *read_harmlessconf(char *path, void **pointer);
void free_harmlessconf(command_list_t *);

int convert_alternative();
int convert_multipart();
int convert_none();

#endif		/* _MSG_CONVERT_H */
