/*
 * samma
 *
 * Copyright (C) 2006,2007,2008 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $RCSfile: mailzip.h,v $
 * $Revision: 1.8 $
 * $Date: 2011/07/29 03:03:03 $
 */

#define IDENT   		"samma"
#define SOCKET_FILE     	"/var/run/samma.sock"
#define DEFAULT_TIMEOUT 	120
#define MAX_CONFIG_LINE 	1024
#define OCONN_LENGTH 		30
#define OCONN 			"inet:%d@%s"
#define false  			0
#define true   			1
#define ZIPCONV			0
#define NOZIPCONV		1
#define XHEADER			"X-SaMMA-Enc"
#define MAX_ARGS		4
#define MLFICLOSE		0
#define MLFIABORT		1
#define BEFOR_RCPTCHECK		0
#define AFTER_RCPTCHECK		1
#define CODE_INVALID_FILENAME	"550"
#define XCODE_INVALID_FILENAME	"5.7.1"
#define MESSAGE_INVALID_FILENAME "Your attachment filename may include invalid encoding. Please rename attachment file and resend."

/* milter */
sfsistat mlfi_connect(SMFICTX *, char *, _SOCK_ADDR *);
sfsistat mlfi_helo(SMFICTX *, char *);
sfsistat mlfi_envfrom(SMFICTX *, char **);
sfsistat mlfi_envrcpt(SMFICTX *, char **);
sfsistat mlfi_header(SMFICTX *, char *, char *);
sfsistat mlfi_eoh(SMFICTX *);
sfsistat mlfi_body(SMFICTX *, u_char *, size_t);
sfsistat mlfi_eom(SMFICTX *);
sfsistat mlfi_close(SMFICTX *);
sfsistat mlfi_abort(SMFICTX *);

/* extern */
extern sfsistat  mlfi_cleanup(SMFICTX *, int);

/* milter struct */
struct smfiDesc smfilter =
{
    IDENT,
    SMFI_VERSION,   /* version code -- do not change */
    SMFIF_DELRCPT,  /* flags */
    mlfi_connect,   /* connection info filter */
    //NULL,   /* connection info filter */
    //NULL,           /* SMTP HELO command filter */
    mlfi_helo,           /* SMTP HELO command filter */
    mlfi_envfrom,   /* envelope sender filter */
    mlfi_envrcpt,   /* envelope recipient filter */
    mlfi_header,    /* header filter */
    mlfi_eoh,       /* end of header */
    mlfi_body,      /* body block filter */
    mlfi_eom,       /* end of message */
    mlfi_abort,     /* message aborted */
    mlfi_close      /* connection cleanup */
};

/* mail save struct */
struct mlfiPriv
{
    struct config   *mlfi_conf;
    struct rcptaddr *mlfi_savercpt;
    char            *mlfi_savefrom;
    struct mailinfo *mlfi_minfo;
    struct rcptinfo *mlfi_passlist;
    struct rcptinfo *mlfi_rdmpasslist;
    int		    mlfi_rcptcheck;
};

pthread_t              child;
