#!/bin/sh

MAXNUM=15

usage()
{
    echo "Usage: convert.sh [ -e|-w|-j|-s ] [ -MB|-MQ ] [Subject String] [filename]"
    exit -1
}

set_strcode()
{
    case $1 in
	-e)
	    STRCODE=$1
	    CHARSET="EUC-JP"
	;;
	-j)
	    STRCODE=$1
	    CHARSET="ISO-2022-JP"
	;;
	-s)
	    STRCODE=$1
	    CHARSET="SHIFT_JIS"
	;;
	-w)
	    STRCODE=$1
	    CHARSET="UTF-8"
	;;
	*)
	    usage
	    exit -1
	;;
    esac
}

set_mime()
{
    case $1 in
	-MB)
	    MIME=$1
	    METHOD="B"
	;;
	-MQ)
	    MIME=$1
	    METHOD="Q"
	;;
	*)
	    usage
	;;
    esac
}

if [ $# -ne 4 ];
then
    usage
fi

set_strcode $1
set_mime $2

SUBJECT_STR=$3
if [ ${#SUBJECT_STR} -gt $MAXNUM ];
then
    echo "Please shorten the subject."
    exit -1
fi

FILENAME=$4

STR=`echo $SUBJECT_STR | nkf $STRCODE $MIME`
SUBJECT="NO"
for VAR in $STR;
do
    PART=`printf "=?%s?%s?%s?=" $CHARSET $METHOD $VAR`
    if [ $SUBJECT == "NO" ];
    then
	SUBJECT=$PART
    else
        SUBJECT=`printf "%s\n\s%s" $SUBJECT $PART`
    fi
done

nkf $STRCODE --overwrite $FILENAME

perl -pe "s/^Subject:.*$/Subject: $SUBJECT/i" < $FILENAME > $FILENAME.$$
mv $FILENAME.$$ $FILENAME
