#include <stdio.h>
#include <gmime/gmime.h>

#define GMIME_ENABLE_RFC2047_WORKAROUNDS  (1 << 0)

int
main(int argc, char *argv[])
{
    GMimeStream *r_stream, *w_stream;
    GMimeParser *parser;
    GMimeMessage *message;
    GMimeObject *object, *att;
    GMimeDataWrapper *wrapper;
    FILE *rfp, *wfp;
    char *tmpdir, *tmpstr;
    char tmpfilename[PATH_MAX + 1];
    const char *filename;
    int ret, rfd;
    int count = 0;
    struct attach_list *alp;
    char *p_filename;
    size_t att_file_len;
    int i, len, index;

    if (argc != 3) {
	fprintf(stderr, "usage: parsemail mailpath destdir");
	return -1;
    }

    g_mime_init(GMIME_ENABLE_RFC2047_WORKAROUNDS);

    /* open file */
    rfp = fopen(argv[1], "r");
    if (rfp == NULL) {
	fprintf(stderr, "file open error.(%s)\n", argv[1]);
    	g_mime_shutdown();
        return -1;
    }
    r_stream = g_mime_stream_file_new (rfp);

    /* parser */
    parser = g_mime_parser_new_with_stream(r_stream);
    g_object_unref (r_stream);

    /* gmime object */
    message = g_mime_parser_construct_message(parser);
    if (message == NULL) {
	fprintf(stderr, "Cannot create message object\n");
        g_object_unref (parser);
    	g_mime_shutdown();
        return -1;
    }
    g_object_unref (parser);

    /* gmime part object */
    object = g_mime_message_get_mime_part(message);

    if (!GMIME_IS_MULTIPART (object)) {
        g_object_unref (object);
	fprintf(stderr, "not attache file\n");
    	g_mime_shutdown();
        return 1;
    }

    /* get attach file number */
    index = g_mime_multipart_get_number((GMimeMultipart *)object);
    if (index > 3) {
        g_object_unref (object);
	fprintf(stderr, "There are two attached files or more. \n");
    	g_mime_shutdown();
        return 1;
    }

    for (i = index - 1; i > 0; i--) {
        att = g_mime_multipart_get_part((GMimeMultipart *)object, i);

        /* get filename */
        filename = g_mime_part_get_filename((GMimePart *)att);
        if (filename == NULL) {
            g_object_unref (att);
            continue;
        }

        snprintf(tmpfilename, PATH_MAX, "%s/%s", argv[2], filename);

        wfp = fopen(tmpfilename, "w");
        if (wfp == NULL) {
	    fprintf(stderr, "file open error.(%s)\n", tmpfilename);
            g_object_unref (att);
            g_object_unref (object);
    	    g_mime_shutdown();
            return -1;
        }

        w_stream = g_mime_stream_file_new (wfp);
        wrapper = g_mime_part_get_content_object((GMimePart *)att);
        if (wrapper == NULL) {
	    fprintf(stderr, "Cannot create wrapper object.\n");
            g_object_unref (att);
            g_object_unref (object);
            g_object_unref (w_stream);
    	    g_mime_shutdown();
            return -1;
        }

        ret = g_mime_data_wrapper_write_to_stream(wrapper, w_stream);
        if (ret < 0) {
	    fprintf(stderr, "Cannot write wrapper object.\n");
            g_object_unref (att);
            g_object_unref (object);
            g_object_unref (w_stream);
            g_object_unref (wrapper);
    	    g_mime_shutdown();
            return -1;
        }

        g_object_unref (w_stream);
        g_object_unref (wrapper);
        g_object_unref (att);
    }
    g_object_unref (object);

    g_mime_shutdown();

    return 0;
}
