#!/bin/sh

SUFIX=$2
PROG=samma
TMPFILE=testmail${SUFIX}
HOMEDIR=`pwd`
CONFDIR=/usr/local/etc/samma
PORT=25
HOST=localhost
RCPTDBTXT=${CONFDIR}/rcptdb.txt
RCPTDB=${CONFDIR}/rcpt.db
SENDDBTXT=${CONFDIR}/senderdb.txt
SENDDB=${CONFDIR}/sender.db
DBTYPE=hash
TMPLFILE=${CONFDIR}/samma.tmpl

set_sender()
{
    # set sender
    case $1 in
        [1-7])
            SENDER="send0$1${SUFIX}@send$1.designet.co.jp"
            SUSER="send0$1${SUFIX}"
        ;;
        *)
            echo "not found SENDER($1)"
            #exit
        ;;
        esac
}

set_rcpt()
{
    # set rcpt
    case $1 in
        0)
            TMPRCPT=""
            TMPRUSER=""
        ;;
        [1-6])
            TMPRCPT="rcpt0$1${SUFIX}@rcpt$1.designet.co.jp"
            TMPRUSER="rcpt0$1${SUFIX}"
	;;
        [7-9])
            TMPRCPT="rcpt0$1${SUFIX}@sub.rcpt$1.designet.co.jp"
            TMPRUSER="rcpt0$1${SUFIX}"
        ;;
        10)
            TMPRCPT="rcpt10${SUFIX}@rcpt10.designet.co.jp"
            TMPRUSER="rcpt10${SUFIX}"
        ;;
        *)
            echo "not found RCPT($1)"
            #exit
        ;;
        esac
}

make_mail()
{
    cat header > ${TMPFILE}

    if [ $1 -eq 0 ] && [ $2 -eq 0 ] && [ $3 -eq 0 ];
    then
        echo "" >> ${TMPFILE}
        cat body >> ${TMPFILE}
    else
        cat multiheader >> ${TMPFILE}
        echo "" >> ${TMPFILE}
        cat multibody >> ${TMPFILE}
    fi

    set_file $1
    set_file $2
    set_file $3

    if [ $1 -eq 0 -a $2 -eq 0 -a $3 -eq 0 ];
    then
        echo "." >> ${TMPFILE}
    else
        cat multifooter >> ${TMPFILE}
        echo "." >> ${TMPFILE}
    fi
}

set_file()
{
    # set attach file
    case $1 in
        0)
        ;;
        1)
            cat ${HOMEDIR}/PMSG/test1.txt >> ${TMPFILE}
        ;;
        2)
            cat ${HOMEDIR}/PMSG/test2.txt >> ${TMPFILE}
        ;;
        *)
            echo "not found FILE($1)"
	    #exit
        ;;
        esac
}

##########################################################################
# init
##########################################################################
if [ `/usr/bin/id -u` -ne 0 ];
then
    echo "Please execute by \"root\" user."
    exit
fi

if [ $# -ne 2 ];
then
    echo "usage: policy.sh [pattern file] [num]"
    exit
fi

if [ ! -f $1 ];
then
    echo "invalid pattern file"
    exit
fi

for NUM in 01 02 03 04 05 06 07
do
    /bin/grep send${NUM}${SUFIX} /etc/passwd > /dev/null 2>&1
    if [ $? -ne 0 ];
    then
        /usr/sbin/useradd send${NUM}${SUFIX}
    fi
done

for NUM in 01 02 03 04 05 06 07 08 09 10
do
    /bin/grep rcpt${NUM}${SUFIX} /etc/passwd > /dev/null 2>&1
    if [ $? -ne 0 ];
    then
        /usr/sbin/useradd rcpt${NUM}${SUFIX}
    fi
done

grep "send01${SUFIX}@send1.designet.co.jp" ${SENDDBTXT} > /dev/null 2>&1
if [ $? -ne 0 ];
then
    echo "send01${SUFIX}@send1.designet.co.jp" >> ${SENDDBTXT}
fi
grep "!send02${SUFIX}@send2.designet.co.jp" ${SENDDBTXT} > /dev/null 2>&1
if [ $? -ne 0 ];
then
    echo "!send02${SUFIX}@send2.designet.co.jp" >> ${SENDDBTXT}
fi
/usr/sbin/makemap -e ${DBTYPE} ${SENDDB} < ${SENDDBTXT}
if [ $? -ne 0 ];
then
    echo "make sender db faild"
    exit 1
fi

grep "rcpt01${SUFIX}@rcpt1.designet.co.jp address" ${RCPTDBTXT} > /dev/null 2>&1
if [ $? -ne 0 ];
then
    echo "rcpt01${SUFIX}@rcpt1.designet.co.jp address" >> ${RCPTDBTXT}
fi
grep "rcpt02${SUFIX}@rcpt2.designet.co.jp" ${RCPTDBTXT} > /dev/null 2>&1
if [ $? -ne 0 ];
then
    echo "rcpt02${SUFIX}@rcpt2.designet.co.jp" >> ${RCPTDBTXT}
fi
grep "!rcpt03${SUFIX}@rcpt3.designet.co.jp" ${RCPTDBTXT} > /dev/null 2>&1
if [ $? -ne 0 ];
then
    echo "!rcpt03${SUFIX}@rcpt3.designet.co.jp" >> ${RCPTDBTXT}
fi
/usr/sbin/makemap -e ${DBTYPE} ${RCPTDB} < ${RCPTDBTXT}
if [ $? -ne 0 ];
then
    echo "make rcpt db faild"
    exit 1
fi

##########################################################################
# main
##########################################################################
cat $1 | while read P S R1 R2 R3 F1 F2 F3 RS RR1 RR2 RR3
do
    echo $P $S $R1 $R2 $R3 $F1 $F2 $F3 $RS $RR1 $RR2 $RR3

    # set sender and recipien
    set_sender ${S}
    set_rcpt ${R1}
    RCPT1=${TMPRCPT}
    RUSER1=${TMPRUSER}
    set_rcpt ${R2}
    RCPT2=${TMPRCPT}
    RUSER2=${TMPRUSER}
    set_rcpt ${R3}
    RCPT3=${TMPRCPT}
    RUSER3=${TMPRUSER}

    # make mail
    make_mail ${F1} ${F2} ${F3} 

    # set mail
    cp ${TMPFILE} ${HOMEDIR}/virus${SUFIX}.txt

    # remove mail
    #/bin/rm -f /home/rcpt*${SUFIX}/Maildir/new/*

    # send mail
    ${HOMEDIR}/rlytest -f ${SENDER} -p ${PORT} ${HOST} ${RCPT1} ${RCPT2} ${RCPT3} > /dev/null 2>&1
    if [ $? -ne 0 ];
    then
        echo "send mail error"
    fi

    sleep 1

done

######################################################################
# shutdown
######################################################################
