<?php
// $Id: rpc_functions.php,v 1.1 2004/07/11 10:28:46 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: i-Tech (Half-Dead)
// Author Website : http://www.i-Technology.NET
// License Type   : LGPL: See /manual/LICENSES/LGPL.txt
// ------------------------------------------------------------------------- //

error_reporting (2039);
set_error_handler("return_error");
//------------------------------------------------------------------------------------------//

/**
* Global functions used in various parts of the package.
* @author Half-Dead
* @copyright 2002 {@link http://www.e-xoops.com www.e-xoops.com} :: {@link http://www.topsite-toplist.com www.topsite-toplist.com}
* @version 1.2b
* @package phpRPC
*/

//------------------------------------------------------------------------------------------//
/**
* @access private
*/
function return_error($errno, $errstr, $errfile='', $errline='') {
global $phprpc_encoding;

if ($errno != 8) {

$serror='<?xml version="1.0" encoding="'.$phprpc_encoding.'"?>' . "\n" .
	'<methodResponse>' . "\n" .
	'  <fault>' . "\n" .
	'    <value>' . "\n" .
	'      <struct>' . "\n" .
	'        <member>' . "\n" .
	'          <name>faultCode</name>' . "\n" .
	'          <value><int>' . $errno . '</int></value>' . "\n" .
	'        </member>' . "\n" .
	'        <member>' . "\n" .
	'          <name>faultString</name>' . "\n" .
	'          <value><string>'.$errstr.' '.$errfile.' '.$errline.'</string></value>' . "\n" .
	'        </member>' . "\n" .
	'      </struct>' . "\n" .
	'    </value>' . "\n" .
	'  </fault>' . "\n" .
	'</methodResponse>';

	header('User-Agent: phpRPC');
	header('Content-Type: text/xml');
	header('Content-length: ' . strlen($serror));
	echo($serror);
	exit();
}
}


//------------------------------------------------------------------------------------------//
/**
* Loads extra functions used in various scripts.
*
* Usage:
* i.E: load_function("xoops.isAdmin");
*
* Extra functions are stored in ./include/functions/
* These can be invoked where needed with this command.
* Like this extra functions can be added without hacking the core files.
* @param string $function Loads extra required functions.
*/
function load_function($function) {
global $phprpc_cms;

if ( preg_match("/[.]/", $function) ) {
	$path = "./include/functions/$phprpc_cms/" . str_replace('.', '/', $function) . ".php";
	} else {
		$path = "./include/functions/$phprpc_cms/" . $function . ".php";
	}

if ( @is_file($path) ) {
	require_once($path);
	} else {
		trigger_error(_phpRPC_NoFunc . $function, E_USER_ERROR);
	}

}


//------------------------------------------------------------------------------------------//
/**
* Encodes an array to UTF-8.
* @access private
* @param $array The array to encode.
* @return array UTF-8 encoded array
*/
function utf8_encode_array(&$array, $key) {
if ( is_array($array) ) {
	array_walk($array, "$this->utf8_encode_array");
	} else {
	$array = utf8_encode($array);
	}
}


//------------------------------------------------------------------------------------------//
/**
* Decodes a UTF-8 encoded array to ISO-8859-1.
* @access private
* @param $array The array to decode.
* @return array ISO-8859-1 encoded array
*/
function utf8_decode_array(&$array, $key) {
if ( is_array($array) ) {
	array_walk($array, "$this->utf8_decode_array");
	} else {
	$array = utf8_decode($array);
	}
}


//------------------------------------------------------------------------------------------//
/**
* Encodes unix timestamp format to iso8601 time format.
* @access private
* @param integer $time Takes unix timestamp as input
* @return string Returns the datetime in iso8601 format. UTC
*/
function iso8601_encode($time) {
	$iso8601_Date = gmstrftime("%Y%m%dT%H:%M:%S", $time);
	return $iso8601_Date;
}


//------------------------------------------------------------------------------------------//
/**
* Decodes iso8601 time format to unix timestamp format
* @access private
* @param string $iso8601_Date Takes iso8601 string as input
* @return integer Returns the datetime in unix timestamp format. UTC
*/
function iso8601_decode($iso8601_Date) {
if (ereg("([0-9]{4})([0-9]{2})([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})", $iso8601_Date, $regs)) {
	$time = gmmktime($regs[4], $regs[5], $regs[6], $regs[2], $regs[3], $regs[1]);
	} else { $time = time(); }
	return $time;
}


//------------------------------------------------------------------------------------------//
/**
* Escapes characters above 127 with their numeric html equivalent.
*
* @param string $string Numericly escapes string.
* @return string Escaped string
*/
function numeric_escape($string) {
	$trans_array = array();
		for ($i=128; $i<256; $i++) {
			$trans_array[chr($i)] = "&#" . $i . ";";
		}
	$string = unhtmlentities($string);
	$string = strtr($string, $trans_array);

return $string;
}


//------------------------------------------------------------------------------------------//
/**
* Escapes characters above 127 with their numeric html equivalent.
*
* @param string $string .
* @param string $mode HTML translation table to use: default ENT_QUOTES
* @return string Numericly escaped string.
*/
function unhtmlentities($string, $mode=ENT_QUOTES)  {
	$trans_tbl = get_html_translation_table (HTML_ENTITIES, $mode);
	$trans_tbl = array_flip ($trans_tbl);

	$string = strtr($string, $trans_tbl);
	$string = preg_replace("/&#([0-9]+);/me", "chr('\\1')", $string);

return  $string;
}

//------------------------------------------------------------------------------------------//
/**
* Encodes/Decodes a string
* ' " < > & are converted to their html counterparts and back.
*
* @param string $string String to process.
* @param string $encode 1/0 Wheteher to encode or decode the string.
* @return string Encoded or Decoded string.
*/
function xml_quote($string, $encode=1) {

if ( !empty($encode) ) {
	$string = str_replace("'", "&#039;", $string);
	$string = str_replace('"', "&quot;", $string);
	$string = str_replace("<", "&lt;"  , $string);
	$string = str_replace(">", "&gt;"  , $string);
	$string = str_replace("&", "&amp;" , $string);

	} else {
	$string = str_replace("&#039;", "'", $string);
	$string = str_replace("&quot;", '"', $string);
	$string = str_replace("&lt;"  , "<", $string);
	$string = str_replace("&gt;"  , ">", $string);
	$string = str_replace("&amp;" , "&", $string);
	}

return $string;
}


//------------------------------------------------------------------------------------------//
/**
* Extracts the text from a given html tag.
*
* @param string $tag Tag to look for.
* @param string $string Input string to process
* @return string Extracted text
*/
function extractFromTag($tag, $string) {

	$string = unhtmlentities($string);
	preg_match("/<" . $tag .">(.+?)<\/".$tag.">/is", $string, $match);

if ( !empty($match[1]) ) {
	return trim($match[1]);
	}
}


//------------------------------------------------------------------------------------------//
/**
* Dumps data to /cache/logs/ for debugging purposes.
*
* @param string $data The output data to write.
* @param string $name Name of the file to output to.
*/
function dump_data($data, $name) {

	$logfile = './cache/logs/'.time().'_'.$name;
	$fp = fopen($logfile, 'w');
	fwrite($fp, $data);
	fclose($fp);
}
//------------------------------------------------------------------------------------------//
?>
