# --------------------------------------------------------

#
# Table structure for table `bb_categories`
#

CREATE TABLE bb_categories (
  cat_id mediumint(8) unsigned NOT NULL auto_increment,
  cat_title varchar(60) NOT NULL default '',
  cat_order smallint(3) NOT NULL default '0',
  PRIMARY KEY  (cat_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `bb_forum_access`
#

CREATE TABLE bb_forum_access (
  forum_id mediumint(8) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0',
  can_post tinyint(1) unsigned NOT NULL default '0'
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `bb_forum_mods`
#

CREATE TABLE bb_forum_mods (
  forum_id mediumint(8) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0'
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `bb_forums`
#

CREATE TABLE bb_forums (
  forum_id mediumint(8) unsigned NOT NULL auto_increment,
  forum_name varchar(60) NOT NULL default '',
  forum_desc text,
  forum_access tinyint(2) unsigned NOT NULL default '1',
  forum_topics mediumint(8) unsigned NOT NULL default '0',
  forum_posts mediumint(8) unsigned NOT NULL default '0',
  forum_last_post_id mediumint(8) unsigned NOT NULL default '0',
  cat_id mediumint(8) unsigned NOT NULL default '0',
  forum_type tinyint(1) unsigned NOT NULL default '0',
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_sig tinyint(1) unsigned NOT NULL default '0',
  posts_per_page tinyint(3) unsigned NOT NULL default '20',
  hot_threshold tinyint(3) unsigned NOT NULL default '10',
  topics_per_page tinyint(3) unsigned NOT NULL default '20',
  PRIMARY KEY  (forum_id),
  KEY idx (cat_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `bb_posts`
#

CREATE TABLE bb_posts (
  post_id mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  topic_id mediumint(8) unsigned NOT NULL default '0',
  forum_id mediumint(8) unsigned NOT NULL default '0',
  post_time int(10) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  poster_ip varchar(15) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  post_text text NOT NULL,
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '1',
  type enum('admin','user') NOT NULL default 'user',
  icon varchar(255) NOT NULL default '',
  attachsig tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (post_id),
  KEY idx (topic_id)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `bb_topics`
#

CREATE TABLE bb_topics (
  topic_id mediumint(8) unsigned NOT NULL auto_increment,
  topic_title varchar(60) NOT NULL default '',
  topic_poster mediumint(8) unsigned NOT NULL default '0',
  topic_time int(10) unsigned NOT NULL default '0',
  topic_views mediumint(8) unsigned NOT NULL default '0',
  topic_replies mediumint(8) unsigned NOT NULL default '0',
  topic_last_post_id mediumint(8) unsigned NOT NULL default '0',
  forum_id mediumint(8) unsigned NOT NULL default '0',
  topic_status tinyint(1) unsigned NOT NULL default '0',
  topic_notify tinyint(1) unsigned NOT NULL default '0',
  topic_sticky tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (topic_id),
  KEY idx (forum_id)
) TYPE=MyISAM;
