require 'rumix'
require '__wxautoload' # generated by Rake
require 'wxconstructor'


module Rumix
	def self.run_on_thread(&proc)
		stop_running_thread
	
		Thread.abort_on_exception = true
		
		thread = Thread.new{
			begin
				proc.call
			rescue Exception
				open(File.join(Rumix.base_dir, 'operation_error.log'), 'w'){|f|
					f.puts $!.to_s
					f.puts $!.backtrace
				}
				Kernel.raise $!
			end
		}
		timer = Wx::Timer.every(1) do
			Thread.pass
		end
		
		@running_thread = thread
		@running_timer = timer
		
		return thread
	end
	
	def self.stop_running_thread
		if @running_thread then
			@running_thread.kill
		end
		
		if @running_timer then
			@running_timer.stop
		end
	end
	
	module Widget
		TITLE_FONT = Wx::Font.new(12, Wx::FONTFAMILY_DEFAULT, Wx::FONTSTYLE_NORMAL, Wx::FONTWEIGHT_BOLD)
		MAIN_SIZER_BORDER = 12
		

		class OptionItem
			attr_reader :name, :label, :description, :selected, :options
		
			def initialize(name, label, desc = nil, selected = false, opts = {})
				@name, @label, @description, @selected, @options = name, label, desc, selected, opts
			end
		end

		
		class TitleText < Wx::StaticText
			def initialize(*args)
				super
				self.font = TITLE_FONT
			end
		end


	
		class OptionPanel < Wx::Panel
			def initialize(parent, items)
				super(parent)
				
				construct_children do |panel|
					# ラジオグループ全体を入れるSizer
					topsz = vbox_sizer do
						vertical_border 8
						expand
						items.each_with_index do |item, i|
							# 各ラジオボタンの関連パーツをまとめるSizer
							vbox_sizer do
								expand
								widget panel.option_widget_class, :name => item.name, :label => item.label, :style => (i == 0 ? Wx::RB_GROUP : 0) do |widget|
									widget.value = item.selected
								end
			
								if item.description then
									# 付帯情報領域と左マージンを含んだSizer
									hbox_sizer do
										stretch_spacer 1
										proportion 11
										# 付帯情報領域のSizer
										static_vbox_sizer('') do
											widget Wx::StaticText, :label => item.description do |text|
												text.name = item.options[:description_name] if item.options[:description_name]
											end
											
											if item.options[:path_name] then
												expand
												hbox_sizer do
													border 4
													proportion 1
													widget Wx::TextCtrl, :name => (item.options[:path_name] + '_text'), :value => item.options[:path_default]
													proportion 0
													widget Wx::Button, :label => '参照', :name => (item.options[:path_name] + '_button') do |button|
														panel.evt_button(button, :on_select_dir)
													end # widget
												end # sizer
											end # if
										end # static_vbox_sizer
										
									end # hbox_sizer
								end # if item.description
							end # vbox_sizer
						end # items.each_with_index
					end # topsz
					
					topsz.fit(panel)
							
				end
			end
			
			def on_select_dir(evt)
				text = find_window_by_name(evt.event_object.name.sub(/_button$/, '_text'))
				dialog = Wx::DirDialog.new(self, :default_path => text.value)
				if dialog.show_modal == Wx::ID_OK then
					text.value = dialog.path
				end
				
			end
	
		end
		
		class RadioOptionPanel < OptionPanel
			def option_widget_class 
				Wx::RadioButton
			end
		end
		
		class CheckOptionPanel < OptionPanel
			def option_widget_class 
				Wx::CheckBox
			end
		end

	end
end