
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate ( cube )



procedure cubic( 
	rr : float;  
	perm : permtype
	) is







procedure ccwNx( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

--put_line("k="&integer'image(k)); -- 1

	Vertices(k+ 0):=xm;	Vertices(k+ 1):=ym;	Vertices(k+ 2):=zm;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=ym;	Vertices(k+ 5):=zp;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=yp;	Vertices(k+ 8):=zp;

	Vertices(k+ 9):=xm;	Vertices(k+10):=ym;	Vertices(k+11):=zm;
	Vertices(k+12):=xm;	Vertices(k+13):=yp;	Vertices(k+14):=zp;
	Vertices(k+15):=xm;	Vertices(k+16):=yp;	Vertices(k+17):=zm;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwNx;

procedure ccwPx( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=ym;	Vertices(k+ 2):=zm;
	Vertices(k+ 3):=xp;	Vertices(k+ 4):=yp;	Vertices(k+ 5):=zp;
	Vertices(k+ 6):=xp;	Vertices(k+ 7):=ym;	Vertices(k+ 8):=zp;

	Vertices(k+ 9):=xp;	Vertices(k+10):=ym;	Vertices(k+11):=zm;
	Vertices(k+12):=xp;	Vertices(k+13):=yp;	Vertices(k+14):=zm;
	Vertices(k+15):=xp;	Vertices(k+16):=yp;	Vertices(k+17):=zp;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwPx;





procedure ccwNy( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=ym;	Vertices(k+ 2):=zp;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=ym;	Vertices(k+ 5):=zm;
	Vertices(k+ 6):=xp;	Vertices(k+ 7):=ym;	Vertices(k+ 8):=zm;

	Vertices(k+ 9):=xp;	Vertices(k+10):=ym;	Vertices(k+11):=zp;
	Vertices(k+12):=xm;	Vertices(k+13):=ym;	Vertices(k+14):=zp;
	Vertices(k+15):=xm;	Vertices(k+16):=ym;	Vertices(k+17):=zm;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwNy;

procedure ccwPy( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=yp;	Vertices(k+ 2):=zp;
	Vertices(k+ 3):=xp;	Vertices(k+ 4):=yp;	Vertices(k+ 5):=zm;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=yp;	Vertices(k+ 8):=zm;

	Vertices(k+ 9):=xp;	Vertices(k+10):=yp;	Vertices(k+11):=zp;
	Vertices(k+12):=xm;	Vertices(k+13):=yp;	Vertices(k+14):=zm;
	Vertices(k+15):=xm;	Vertices(k+16):=yp;	Vertices(k+17):=zp;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwPy;







procedure ccwNz( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=yp;	Vertices(k+ 2):=zm;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=ym;	Vertices(k+ 5):=zm;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=yp;	Vertices(k+ 8):=zm;

	Vertices(k+ 9):=xp;	Vertices(k+10):=yp;	Vertices(k+11):=zm;
	Vertices(k+12):=xp;	Vertices(k+13):=ym;	Vertices(k+14):=zm;
	Vertices(k+15):=xm;	Vertices(k+16):=ym;	Vertices(k+17):=zm;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwNz;

procedure ccwPz( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;


begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=yp;	Vertices(k+ 2):=zp;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=yp;	Vertices(k+ 5):=zp;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=ym;	Vertices(k+ 8):=zp;

	Vertices(k+ 9):=xp;	Vertices(k+10):=yp;	Vertices(k+11):=zp;
	Vertices(k+12):=xm;	Vertices(k+13):=ym;	Vertices(k+14):=zp;
	Vertices(k+15):=xp;	Vertices(k+16):=ym;	Vertices(k+17):=zp;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwPz;








-- Solution to IQube:
-- red layout to match iqube1.gif:
--
--r u x
--  s v y
--		t w z
--j m o
--	 k   p
--		l n q
--a d g
--	 b e h
--		c f i

--// this version generates colors for iQube:
--// solution:  exterior = red

--// other sides I shall attempt to match
--// the analysis on jaap's page (iqube1.gif)

procedure iqubelet( xc,yc,zc,rr : float;  kk, p : integer ) is
begin

	amyassert( p>=0, 224 );
	amyassert( p<=26, 225 );

--
-- +x=right, +y=up, +z=out
--

case p  is

	when  0 => --a llp (x,y,z = left, lower, posterior)
		-- lef,rit, bot,top, pos,ant = red,yel, red,grn, red,yel

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when  1 => --b llm
		-- lef,rit, bot,top, pos,ant = red,yel, red,grn, yel,grn

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when  2 => --c lla (x,y,z = lef, low, anterior)
		-- lef,rit, bot,top, pos,ant = red,grn, red,grn, grn,red

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when  3 => --d mlp (x,y,z = Mid, Low, Post)
		-- lef,rit, bot,top, pos,ant = grn,yel, red,yel, red,yel

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when  4 => --e mlm
		-- lef,rit, bot,top, pos,ant = grn,yel, red,yel, yel,grn

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when  5 => --f mla
		-- lef,rit, bot,top, pos,ant = yel,grn, red,yel, yel,red

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when  6 => --g rlp (x,y,z = Right, Low, Post)
		-- lef,rit, bot,top, pos,ant = grn,red, red,grn, red,grn

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when  7 => --h rlm
		-- lef,rit, bot,top, pos,ant = yel,red, red,yel, grn,yel

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when  8 => --i rla
		-- lef,rit, bot,top, pos,ant = grn,red, red,grn, grn,red

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(1.0,0.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=0.0; blu(6*p+3):=0.0; --red
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when  9 => --j lmp (x,y,z = Left, Mid, Post)
		-- lef,rit, bot,top, pos,ant = red,grn, yel,grn, red,yel

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when 10 => --k lmm
		-- lef,rit, bot,top, pos,ant = red,yel, yel,grn, grn,yel

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when 11 => --l lma
		-- lef,rit, bot,top, pos,ant = red,yel, grn,yel, grn,red

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when 12 => --m mmp
		-- lef,rit, bot,top, pos,ant = yel,grn, yel,grn, red,grn

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when 13 => --blank mmm
		null;

	when 14 => --n mma
		-- lef,rit, bot,top, pos,ant = grn,yel, yel,grn, yel,red

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(0.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=0.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --grn

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when 15 => --o rmp
		-- lef,rit, bot,top, pos,ant = yel,red, grn,yel, red,grn

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when 16 => --p rmm
		-- lef,rit, bot,top, pos,ant = grn,red, grn,yel, grn,yel

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when 17 => --q rma
		-- lef,rit, bot,top, pos,ant = grn,red, grn,yel, yel,red

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,1.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=1.0; blu(6*p+4):=0.0; --yel

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when 18 => --r ltp
		-- lef,rit, bot,top, pos,ant = red,grn, grn,red, red,grn

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when 19 => --s ltm
		-- lef,rit, bot,top, pos,ant = red,grn, yel,red, yel,grn

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when 20 => --t lta
		-- lef,rit, bot,top, pos,ant = red,grn, grn,red, grn,red

		ccwNx(1.0,0.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=0.0; blu(6*p+1):=0.0; --red
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when 21 => --u mtp
		-- lef,rit, bot,top, pos,ant = yel,grn, grn,red, red,yel

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when 22 => --v mtm
		-- lef,rit, bot,top, pos,ant = yel,grn, yel,red, grn,yel

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(0.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=0.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --grn

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --yel

	when 23 => --w mta
		-- lef,rit, bot,top, pos,ant = grn,yel, yel,red, grn,red

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,1.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=1.0; blu(6*p+2):=0.0; --yel

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(0.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=0.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --grn
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when 24 => --x rtp
		-- lef,rit, bot,top, pos,ant = grn,red, grn,red, red,grn

		ccwNx(0.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=0.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --grn
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(1.0,0.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=0.0; blu(6*p+5):=0.0; --red
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when 25 => --y rtm
		-- lef,rit, bot,top, pos,ant = yel,red, yel,red, yel,grn

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(1.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=1.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --yel
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(0.0,1.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=0.0; grn(6*p+6):=1.0; blu(6*p+6):=0.0; --grn

	when 26 => --z rta
		-- lef,rit, bot,top, pos,ant = yel,red, grn,red, yel,red

		ccwNx(1.0,1.0,0.0,xc,yc,zc,rr,  1+kk);  red(6*p+1):=1.0; grn(6*p+1):=1.0; blu(6*p+1):=0.0; --yel
		ccwPx(1.0,0.0,0.0,xc,yc,zc,rr, 19+kk);  red(6*p+2):=1.0; grn(6*p+2):=0.0; blu(6*p+2):=0.0; --red

		ccwNy(0.0,1.0,0.0,xc,yc,zc,rr, 37+kk);  red(6*p+3):=0.0; grn(6*p+3):=1.0; blu(6*p+3):=0.0; --grn
		ccwPy(1.0,0.0,0.0,xc,yc,zc,rr, 55+kk);  red(6*p+4):=1.0; grn(6*p+4):=0.0; blu(6*p+4):=0.0; --red

		ccwNz(1.0,1.0,0.0,xc,yc,zc,rr, 73+kk);  red(6*p+5):=1.0; grn(6*p+5):=1.0; blu(6*p+5):=0.0; --yel
		ccwPz(1.0,0.0,0.0,xc,yc,zc,rr, 91+kk);  red(6*p+6):=1.0; grn(6*p+6):=0.0; blu(6*p+6):=0.0; --red

	when others => null;

	end case;

end iqubelet;












procedure cubelet( x,y,z,r : float;  kk, p : integer ) is
	k : integer := 1;
begin --cubelet

	if firstcallcubic then
	if x <-0.1 then --green
		red(6*p+1):=0.0;
		grn(6*p+1):=1.0;
		blu(6*p+1):=0.0;
	else            --black
		red(6*p+1):=0.0;
		grn(6*p+1):=0.0;
		blu(6*p+1):=0.0;
	end if;
	end if;

	if rgbskin then
	ccwNx(red27(p+1), grn27(p+1), blu27(p+1), x,y,z,r,  1+kk);
	else
	ccwNx(red(6*p+1), grn(6*p+1), blu(6*p+1), x,y,z,r,  1+kk);
	end if;


	if firstcallcubic then
	if x > 0.1 then --yellow
		red(6*p+2):=0.9;
		grn(6*p+2):=0.9;
		blu(6*p+2):=0.0;
	else            --black
		red(6*p+2):=0.0;
		grn(6*p+2):=0.0;
		blu(6*p+2):=0.0;
	end if;
	end if;

	if rgbskin then
	ccwPx(red27(p+1), grn27(p+1), blu27(p+1), x,y,z,r, 19+kk);
	else
	ccwPx(red(6*p+2), grn(6*p+2), blu(6*p+2), x,y,z,r, 19+kk);
	end if;


	if firstcallcubic then
	if y <-0.1 then --magenta
		red(6*p+3):=1.0;
		grn(6*p+3):=0.0;
		blu(6*p+3):=1.0;
	else            --black
		red(6*p+3):=0.0;
		grn(6*p+3):=0.0;
		blu(6*p+3):=0.0;
	end if;
	end if;

	if rgbskin then
	ccwNy(red27(p+1), grn27(p+1), blu27(p+1), x,y,z,r, 37+kk);
	else
	ccwNy(red(6*p+3), grn(6*p+3), blu(6*p+3), x,y,z,r, 37+kk);
	end if;


	if firstcallcubic then
	if y > 0.1 then --red
		red(6*p+4):=1.0;
		grn(6*p+4):=0.0;
		blu(6*p+4):=0.0;
	else            --black
		red(6*p+4):=0.0;
		grn(6*p+4):=0.0;
		blu(6*p+4):=0.0;
	end if;
	end if;

	if rgbskin then
	ccwPy(red27(p+1), grn27(p+1), blu27(p+1), x,y,z,r, 55+kk);
	else
	ccwPy(red(6*p+4), grn(6*p+4), blu(6*p+4), x,y,z,r, 55+kk);
	end if;


	if firstcallcubic then
	if z <-0.1 then --blue
		red(6*p+5):=0.0;
		grn(6*p+5):=0.0;
		blu(6*p+5):=1.0;
	else            --black
		red(6*p+5):=0.0;
		grn(6*p+5):=0.0;
		blu(6*p+5):=0.0;
	end if;
	end if;

	if rgbskin then
	ccwNz(red27(p+1), grn27(p+1), blu27(p+1), x,y,z,r, 73+kk);
	else
	ccwNz(red(6*p+5), grn(6*p+5), blu(6*p+5), x,y,z,r, 73+kk);
	end if;


	if firstcallcubic then
	if z > 0.1 then --cyan
		red(6*p+6):=0.0;
		grn(6*p+6):=1.0;
		blu(6*p+6):=1.0;
	else            --black
		red(6*p+6):=0.0;
		grn(6*p+6):=0.0;
		blu(6*p+6):=0.0;
	end if;
	end if;

	if rgbskin then
	ccwPz(red27(p+1), grn27(p+1), blu27(p+1), x,y,z,r, 91+kk);
	else
	ccwPz(red(6*p+6), grn(6*p+6), blu(6*p+6), x,y,z,r, 91+kk);
	end if;


end cubelet;








	rrr : constant float := 2.0*rr/3.0;
	k : integer := 0;
	idx,p : rngm;

	xx,yy,zz : float;

	shrink : constant float := 0.95;

	rval, gval, bval : float;

begin --cubic
	for row in rngs loop
		yy := (float(row-1)-1.0)*rrr;
		bval := 0.3 + float(row-1)/3.0;
		for col in rngs loop
			xx := (float(col-1)-1.0)*rrr;
			gval := 0.2 + float(col-1)/3.0;
			for lay in rngs loop
				zz := (float(lay-1)-1.0)*rrr;
				rval := 0.3 + float(lay-1)/3.0;
				idx := indx(row,col,lay);
				p := perm(row,col,lay); --1st call:  p=idx

				if firstcallcubic then --p=idx
					-- here we define the RGB skin colors...
					-- same on all faces of each cubelet
					red27(idx):=rval;
					grn27(idx):=gval;
					blu27(idx):=bval;
				end if;

				if firstcallcubic then
					if p /= idx then
						put_line("FirstCall to cubic was permuted?");
						raise program_error;
					end if;
					xxx(p) := xx;
					yyy(p) := yy; --save for use in moving text
					zzz(p) := zz;
				end if;

				if (row/=brow) or (col/=bcol) or (lay/=blay) then

					-- 16jan20 variation to handle skin cycling:
					if rgbskin or cskin then
						cubelet(xx,yy,zz, shrink*rrr/2.0, k, p-1);--use zero-based p
					else
						iqubelet(xx,yy,zz, shrink*rrr/2.0, k, p-1);--use zero-based p
					end if;


					k := k + 108;
				end if;
			end loop; --for lay
		end loop; --col
	end loop; --row
	firstcallcubic := false;
end cubic;



