#!/usr/local/bin/ruby
# $Id: test_sample.rb,v 1.2 2004/09/28 17:04:47 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/error'
require 'rucy/document'
require 'rucy/loader'

module TestRucy
  class TestParameterSampleDocument < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse

    def setup
      super

      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/sample.rb')
      @ParameterSampleDocument = @loader.const_get('ParameterSampleDocument')
      @sample = @ParameterSampleDocument.new('hi',  # string
					     nil,   # password
					     '<html>Hello world.</html>', # text
					     0,     # number
					     /foo/, # regexp
					     true,  # bool
					     'foo', # select
					     'foo', # radio
					     { 'foo' => true, 'bar' => false, 'baz' => false } # checkset
					     )
    end

    def test_GET
      @request.method ='GET'
      @request.uri = '/'
      @request.version = 'HTTP/1.1'
      @sample.publish('', @request, @response, self)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('text/html', @messg_head.header('Content-Type'))
      assert(! @messg_body.empty?)
    end

    def test_HEAD
      @request.method ='HEAD'
      @request.uri = '/'
      @request.version = 'HTTP/1.1'
      @sample.publish('', @request, @response, self)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('text/html', @messg_head.header('Content-Type'))
      assert(@messg_body.empty?)
    end

    def test_POST
      @request.method ='POST'
      @request.uri = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@sample.publish('', @request, @response, self)
      rescue Rucy::HTTPError
	assert_equal(405, $!.status) # Method Not Allowd
	done = true
      end
      assert(done)
      assert_nil(@messg_head)
      assert(@messg_body.empty?)
    end
  end

  class TestParameterSampleFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super

      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/sample.rb')
      @ParameterSampleFilter = @loader.const_get('ParameterSampleFilter')
      @sample = @ParameterSampleFilter.new('hi',  # string
					   nil,   # password
					   '<html>Hello world.</html>', # text
					   0,     # number
					   /foo/, # regexp
					   true,  # bool
					   'foo', # select
					   'foo', # radio
					   { 'foo' => true, 'bar' => false, 'baz' => false } # checkset
					   )
      @doc = Rucy::FilterDocument.new(self, @sample)
    end

    def test_GET
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end
end
