#!/usr/local/bin/ruby
# $Id: test_restart.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'rucy/restart'

Thread.abort_on_exception = true

module TestRucy
  class TestMultiThreadRestartSignal < RUNIT::TestCase
    def setup
      @restart_call = 0
      @close_call = 0
      @restart_signal = Rucy::MultiThreadRestartSignal.new
      @restart_signal.server = self
    end

    def restart
      @restart_call += 1
      nil
    end

    def close
      @close_call += 1
      nil
    end

    def test_notify_restart
      th_grp = ThreadGroup.new
      begin
	10.times do
	  th_grp.add Thread.new{
	    @restart_signal.notify_restart
	  }
	end
	@restart_signal.wait
	assert_equal(1, @restart_call)
      ensure
	for th in th_grp.list
	  th.join
	end
      end
      assert_equal(1, @restart_call)
    end

    def test_notify_close
      th_grp = ThreadGroup.new
      begin
	10.times do
	  th_grp.add Thread.new{
	    @restart_signal.notify_close
	  }
	end
	@restart_signal.wait
	assert_equal(1, @close_call)
      ensure
	for th in th_grp.list
	  th.join
	end
      end
      assert_equal(1, @close_call)
    end

    def test_cancel
      begin
	th = Thread.new{
	  @restart_signal.wait
	}
	@restart_signal.cancel
	@restart_signal.notify_restart
      ensure
	th.join
      end
      assert_equal(0, @restart_call)
      assert_equal(0, @close_call)
    end
  end
end
