#!/usr/local/bin/ruby
# $Id: test_queue.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'pseudo_io'
require 'rucy/messenger'

module TestRucy
  class TestSocketQueue < RUNIT::TestCase
    def setup
      @queue = Rucy::SocketQueue.new(2)
    end

    def test_push_pop
      @queue.push(PseudoIO.new)
      assert_instance_of(PseudoIO, @queue.pop)
    end

    def test_push_pop_multi_thread
      spin_lock = true
      Thread.new{
	while (spin_lock)
	  # locked.
	end
	@queue.push(PseudoIO.new)
      }
      Thread.new{
	while (spin_lock)
	  # locked.
	end
	@queue.push(PseudoIO.new)
      }
      Thread.new{
	while (spin_lock)
	  # locked.
	end
	@queue.push(PseudoIO.new)
      }
      Thread.new{
	while (spin_lock)
	  # locked.
	end
	@queue.push(PseudoIO.new)
      }

      spin_lock = false
      assert_instance_of(PseudoIO, @queue.pop)
      assert_instance_of(PseudoIO, @queue.pop)
      assert_instance_of(PseudoIO, @queue.pop)
      assert_instance_of(PseudoIO, @queue.pop)
    end

    def test_push_close
      spin_lock1 = true
      spin_lock2 = true

      Thread.new{
	@queue.push(PseudoIO.new)
	@queue.push(PseudoIO.new)
	spin_lock1 = false
	@queue.push(PseudoIO.new)
	@queue.push(PseudoIO.new)
      }

      Thread.new{
	while (spin_lock1)
	  # wait for thread 1.
	end
	@queue.push_close
	@queue.push_close
	spin_lock2 = false
      }

      while (spin_lock2)
	# wait for thread 2.
      end
      assert_equal(Rucy::SocketQueue::CMD_CLOSE, @queue.pop)
      assert_equal(Rucy::SocketQueue::CMD_CLOSE, @queue.pop)
      assert_instance_of(PseudoIO, @queue.pop)
      assert_instance_of(PseudoIO, @queue.pop)
      assert_instance_of(PseudoIO, @queue.pop)
      assert_instance_of(PseudoIO, @queue.pop)
    end
  end
end
