#!/usr/local/bin/ruby
# $Id: test_pseudo_io.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'pseudo_io'

module TestRucy
  class TestPseudoIO < RUNIT::TestCase
    def setup
      @io = PseudoIO.new
    end

    def test_write
      assert_nil(@io.read)
      @io.write("hello")
      @io.write(" ")
      @io.write("world")
      assert_equal("hello world", @io.read)
    end

    def test_print
      assert_nil(@io.read)
      @io.print("hello", " ", "world")
      assert_equal("hello world", @io.read)
    end

    def test_read
      assert_nil(@io.read)
      assert_nil(@io.read(256))

      @io.write('Hello world')
      assert_equal('Hello world', @io.read)

      @io.write('Hello world')
      assert_equal('Hello ', @io.read(6))
      assert_equal('world', @io.read(256))

      assert_nil(@io.read(256))
      assert_nil(@io.read)
    end

    def test_gets
      @io.write("hello\n")
      @io.write("world\n")
      assert_equal("hello\n", @io.gets)
      assert_equal("world\n", @io.gets)
      assert_nil(@io.gets)
    end

    def test_each_line
      @io.write("hello\n")
      @io.write("world\n")

      lines = [
	"hello\n",
	"world\n"
      ]
      @io.each_line do |line|
	assert_equal(lines.first, line)
	lines.shift
      end
      assert_nil(@io.read)
    end

    def test_close
      assert(! @io.closed?)
      @io.write('hello world.')
      assert_equal('hello world.', @io.read)
      @io.close
      assert(@io.closed?)
      assert_exception(RuntimeError) { @io.write('hello world.') }
      assert_exception(RuntimeError) { @io.read }
    end
  end
end
