#!/usr/local/bin/ruby

require 'rubyunit'
require 'rucy/process'

module TestRucy
  class TestProcUtil < RUNIT::TestCase
    include Rucy::ProcUtil

    def test_chenv
      assert_nil(ENV['foo'])
      env_var_alist = ENV.to_a
      chenv({ 'foo' => 'Alice' }) {
	assert_equal('Alice', ENV['foo'])
	for name, value in env_var_alist
	  assert_nil(ENV[name])
	end
      }
      assert_nil(ENV['foo'])
    end
  end
end
