1#!/usr/local/bin/ruby
# $Id: test_passwd.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'rucy/passwd'

module TestRucy
  class TestPasswordEncryptor < RUNIT::TestCase
    def setup
      @pw_enc = Rucy::PasswordEncryptor.new
    end

    def test_salt
      salt = @pw_enc.salt
      salt2 = @pw_enc.salt
      assert(salt != salt2)
      assert(salt.length == salt2.length)
    end

    def test_crypt
      encrypted_password = @pw_enc.crypt('foo')
      assert(encrypted_password != @pw_enc.crypt('foo'))
      assert(encrypted_password != @pw_enc.crypt('bar'))
      assert(encrypted_password == @pw_enc.crypt('foo', encrypted_password))
      assert(encrypted_password != @pw_enc.crypt('bar', encrypted_password))
    end
  end

  class TestPasswordVerifier < RUNIT::TestCase
    def setup
      # for Rucy::PasswordEncryptor class
      @pw_enc = Rucy::PasswordEncryptor.new
      @crypt_call = 0

      @passwd = Rucy::PasswordVerifier.new(self)
    end

    def crypt(*args)
      @crypt_call += 1
      @pw_enc.crypt(*args)
    end

    def test_empty_user
      assert_exception(RuntimeError) {
	@passwd.add_user(nil, 'foo')
      }
      assert_exception(RuntimeError) {
	@passwd.add_user('', 'foo')
      }
      assert_exception(RuntimeError) {
	@passwd.add_user(' ', 'foo')
      }

      assert_exception(RuntimeError) {
	@passwd.add_encrypted_user(nil, 'foo')
      }
      assert_exception(RuntimeError) {
	@passwd.add_encrypted_user('', 'foo')
      }
      assert_exception(RuntimeError) {
	@passwd.add_encrypted_user(' ', 'foo')
      }
    end

    def test_empty_password
      assert_exception(RuntimeError) {
	@passwd.add_user('alice', nil)
      }
      assert_exception(RuntimeError) {
	@passwd.add_user('alice', '')
      }

      assert_exception(RuntimeError) {
	@passwd.add_encrypted_user('alice', nil)
      }
      assert_exception(RuntimeError) {
	@passwd.add_encrypted_user('alice', '')
      }
    end

    def test_add_user_and_verify
      @passwd.add_user('alice', 'foo')
      assert_equal(1, @crypt_call)
      @passwd.add_user('bob', 'bar')
      assert_equal(2, @crypt_call)
      assert(@passwd.verify('alice', 'foo'))
      assert_equal(3, @crypt_call)
      assert(@passwd.verify('bob', 'bar'))
      assert_equal(4, @crypt_call)
      assert(! @passwd.verify('alice', 'bar'))
      assert_equal(5, @crypt_call)
      assert(! @passwd.verify('bob', 'foo'))
      assert_equal(6, @crypt_call)
      assert(! @passwd.verify('carol', 'baz'))
      assert_equal(6, @crypt_call)
    end

    def test_add_encrypted_user_and_verify
      @passwd.add_encrypted_user('alice', @pw_enc.crypt('foo'))
      assert_equal(0, @crypt_call)
      @passwd.add_user('bob', 'bar')
      assert_equal(1, @crypt_call)
      assert(@passwd.verify('alice', 'foo'))
      assert_equal(2, @crypt_call)
      assert(@passwd.verify('bob', 'bar'))
      assert_equal(3, @crypt_call)
      assert(! @passwd.verify('alice', 'bar'))
      assert_equal(4, @crypt_call)
      assert(! @passwd.verify('bob', 'foo'))
      assert_equal(5, @crypt_call)
      assert(! @passwd.verify('carol', 'baz'))
      assert_equal(5, @crypt_call)
    end
  end
end
