#!/usr/local/bin/ruby
# $Id: test_page.rb,v 1.2 2004/10/02 00:42:05 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/error'
require 'rucy/document'
require 'rucy/loader'

module TestRucy
  class TestPageDocument2 < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse

    def setup
      super

      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/page.rb')
      @PageDocument = @loader.const_get('PageDocument')
      @page = @PageDocument.new("<html>Hello world.</html>\n")
    end

    def test_GET
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @page.publish('', @request, @response, @logger)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/html', @messg_head.header('Content-Type'))
      assert_equal('26', @messg_head.header('Content-Length'))
      assert_equal("<html>Hello world.</html>\n", @messg_body)
      assert(@log_emerg.empty?)
      assert(@log_alert.empty?)
      assert(@log_crit.empty?)
      assert(@log_err.empty?)
      assert(@log_warning.empty?)
      assert(@log_notice.empty?)
      assert(@log_info.empty?)
      assert_match(@log_debug, /enter document: Rucy::Page/)
    end

    def test_HEAD
      @request.method = 'HEAD'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @page.publish('', @request, @response, @logger)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/html', @messg_head.header('Content-Type'))
      assert_equal('26', @messg_head.header('Content-Length'))
      assert_equal('', @messg_body)
      assert(@log_emerg.empty?)
      assert(@log_alert.empty?)
      assert(@log_crit.empty?)
      assert(@log_err.empty?)
      assert(@log_warning.empty?)
      assert(@log_notice.empty?)
      assert(@log_info.empty?)
      assert_match(@log_debug, /enter document: Rucy::Page/)
    end
  end
end
