# $Id: test_jconv.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'rucy/jconv'

module TestRucy
  class TestJconv < RUNIT::TestCase
    def test_empty_string
      assert_equal('', Rucy::Jconv.jconv(''))
    end

    def test_ascii
      assert_equal('Hello world.', Rucy::Jconv.jconv('Hello world.'))
    end

    def test_utf8
      assert_equal("\343\201\223\343\202\223\343\201\253\343\201\241\343\201\257\343\200\202",
		   Rucy::Jconv.jconv("\343\201\223\343\202\223\343\201\253\343\201\241\343\201\257\343\200\202"))
    end

    def test_ja_euc
      assert_equal("\343\201\223\343\202\223\343\201\253\343\201\241\343\201\257\343\200\202",
		   Rucy::Jconv.jconv("\244\263\244\363\244\313\244\301\244\317\241\243"))
    end

    def test_ja_sjis
      assert_equal("\343\201\223\343\202\223\343\201\253\343\201\241\343\201\257\343\200\202",
		   Rucy::Jconv.jconv("\202\261\202\361\202\311\202\277\202\315\201B"))
    end
  end
end
