#!/usr/local/bin/ruby
# $Id: test_http_error.rb,v 1.1 2004/04/07 13:59:12 toki Exp $

require 'rubyunit'
require 'rucy/error'

module TestRucy
  class TestHTTPError < RUNIT::TestCase
    def test_500_Internal_Server_Error
      ex = Rucy::HTTPError.new
      assert_instance_of(Rucy::HTTPError, ex)
      assert_equal(500, ex.status)
      assert_equal('500 Internal Server Error', ex.message)
    end

    def test_404_Not_Found
      ex = Rucy::HTTPError.new(404)
      assert_instance_of(Rucy::HTTPError, ex)
      assert_equal(404, ex.status)
      assert_equal('404 Not Found', ex.message)
    end

    def test_404_No_such_file_or_directory
      ex = Rucy::HTTPError.new(404, 'No such file or directory.')
      assert_instance_of(Rucy::HTTPError, ex)
      assert_equal(404, ex.status)
      assert_equal('No such file or directory.', ex.message)
    end

    def test_405_Method_Not_Allowed
      ex = Rucy::HTTPError.new(405)
      ex.set_header('Allow', 'GET, HEAD')
      assert_instance_of(Rucy::HTTPError, ex)
      assert_equal(405, ex.status)
      assert_equal('405 Method Not Allowed', ex.message)
      assert_equal('GET, HEAD', ex.header('Allow'))
      ex.each_header do |name, value|
	assert_equal('Allow', name)
	assert_equal('GET, HEAD', value)
      end
    end
  end
end
