#!/usr/local/bin/ruby
# $Id: test_auth.rb,v 1.4 2004/10/02 00:41:56 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/loader'

module TestRucy
  class TestBasicAuthFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super

      # for Rucy::PasswordVerifier class
      @verify_call = 0
      @verify_last_user = nil
      @verify_last_password = nil

      # target
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/auth.rb')
      @BasicAuthFilter = @loader.const_get('BasicAuthFilter')
      @auth = @BasicAuthFilter.new(self, 'TestAuth')
      @doc = Rucy::FilterDocument.new(self, @auth)
    end

    def verify(user, password)
      @verify_call += 1
      @verify_last_user = user
      @verify_last_password = password
      user == 'alice' && password == 'himitsu'
    end

    def test_allow
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Authorization', 'Basic ' + [ 'alice:himitsu' ].pack('m'))
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @verify_call)
      assert_equal('alice', @verify_last_user)
      assert_equal('himitsu', @verify_last_password)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny_user
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Authorization', 'Basic ' + [ 'bob:himitsu' ].pack('m'))
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(401, $!.status)
	assert_equal('Basic realm="TestAuth"', $!.header('WWW-Authenticate'))
	assert_equal(1, @verify_call)
	assert_equal('bob', @verify_last_user)
	assert_equal('himitsu', @verify_last_password)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_deny_password
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Authorization', 'Basic ' + [ 'alice:detarame' ].pack('m'))
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(401, $!.status)
	assert_equal('Basic realm="TestAuth"', $!.header('WWW-Authenticate'))
	assert_equal(1, @verify_call)
	assert_equal('alice', @verify_last_user)
	assert_equal('detarame', @verify_last_password)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_deny_no_auth
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(401, $!.status)
	assert_equal('Basic realm="TestAuth"', $!.header('WWW-Authenticate'))
	assert_equal(0, @verify_call)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestBasicAuthFilterFactory < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/auth.rb')
      @BasicAuthFilterFactory = @loader.const_get('BasicAuthFilterFactory')
      @factory = @BasicAuthFilterFactory.instance
    end

    def test_set_filter_option
      @factory.set_filter_option({ :pw_enc => Rucy::PasswordEncryptor.new })
    end

    def test_filter_name
      assert_equal('BasicAuth', @factory.filter_name)
    end

    def test_filter_args
      args = @factory.filter_args
      assert_equal([ 'realm', :string, nil ], args[0])
      assert_equal([ 'user 1', :string, nil ], args[1])
      assert_equal([ 'password 1', :password, nil  ], args[2])
      assert_equal([ 'user 2', :string, nil ], args[3])
      assert_equal([ 'password 2', :password, nil  ], args[4])
      assert_equal([ 'user 3', :string, nil ], args[5])
      assert_equal([ 'password 3', :password, nil  ], args[6])
      assert_equal([ 'user 4', :string, nil ], args[7])
      assert_equal([ 'password 4', :password, nil  ], args[8])
      assert_equal([ 'user 5', :string, nil ], args[9])
      assert_equal([ 'password 5', :password, nil  ], args[10])
    end

    def test_new
      filter = @factory.new('test',
			    'foo', 'himitsu',
			    nil, nil,
			    nil, nil,
			    nil, nil,
			    nil, nil)
      assert_instance_of(@loader.const_get('BasicAuthFilter'), filter)
    end
  end
end
