#!/usr/local/bin/ruby
# $Id: test_access.rb,v 1.3 2004/09/29 13:25:01 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/loader'

module TestRucy
  class TestRemoteAddressAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressAllowAccessFilter = @loader.const_get('RemoteAddressAllowAccessFilter')
      @access = @RemoteAddressAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_address('127.0.0.1')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_address('127.0.0.1')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRemoteAddressAllowAccessFilterFactory < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressAllowAccessFilterFactory = @loader.const_get('RemoteAddressAllowAccessFilterFactory')
      @factory = @RemoteAddressAllowAccessFilterFactory.instance
    end

    def test_set_filter_option
      @factory.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteAddressAllowAccess', @factory.filter_name)
    end

    def test_filter_args
      args = @factory.filter_args
      assert_equal("remote address pattern 1 (regexp)", args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal("remote address pattern 2 (regexp)", args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal("remote address pattern 3 (regexp)", args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal("remote address pattern 4 (regexp)", args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal("remote address pattern 5 (regexp)", args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @factory.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteAddressAllowAccessFilter'), filter)
    end
  end

  class TestRemoteAddressDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressDenyAccessFilter = @loader.const_get('RemoteAddressDenyAccessFilter')
      @access = @RemoteAddressDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_address('192.168.0.3')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_address('192.168.0.3')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRemoteAddressDenyAccessFilterFactory < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressDenyAccessFilterFactory = @loader.const_get('RemoteAddressDenyAccessFilterFactory')
      @factory = @RemoteAddressDenyAccessFilterFactory.instance
    end

    def test_set_filter_option
      @factory.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteAddressDenyAccess', @factory.filter_name)
    end

    def test_filter_args
      args = @factory.filter_args
      assert_equal('remote address pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('remote address pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('remote address pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('remote address pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('remote address pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @factory.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteAddressDenyAccessFilter'), filter)
    end
  end

  class TestRemoteHostAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostAllowAccessFilter = @loader.const_get('RemoteHostAllowAccessFilter')
      @access = @RemoteHostAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_name('localhost')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_name('localhost')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRemoteHostAllowAccessFilterFactory < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostAllowAccessFilterFactory = @loader.const_get('RemoteHostAllowAccessFilterFactory')
      @factory = @RemoteHostAllowAccessFilterFactory.instance
    end

    def test_set_filter_option
      @factory.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteHostAllowAccess', @factory.filter_name)
    end

    def test_filter_args
      args = @factory.filter_args
      assert_equal('remote host name pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('remote host name pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('remote host name pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('remote host name pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('remote host name pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @factory.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteHostAllowAccessFilter'), filter)
    end
  end

  class TestRemoteHostDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostDenyAccessFilter = @loader.const_get('RemoteHostDenyAccessFilter')
      @access = @RemoteHostDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_name('foo')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_name('foo')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRemoteHostDenyAccessFilterFactory < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostDenyAccessFilterFactory = @loader.const_get('RemoteHostDenyAccessFilterFactory')
      @factory = @RemoteHostDenyAccessFilterFactory.instance
    end

    def test_set_filter_option
      @factory.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteHostDenyAccess', @factory.filter_name)
    end

    def test_filter_args
      args = @factory.filter_args
      assert_equal('remote host name pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('remote host name pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('remote host name pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('remote host name pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('remote host name pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @factory.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteHostDenyAccessFilter'), filter)
    end
  end

  class TestRequestPathAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathAllowAccessFilter = @loader.const_get('RequestPathAllowAccessFilter')
      @access = @RequestPathAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_path(/foo/)
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/foo/bar', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_path(/baz/)
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRequestPathAllowAccessFilterFactory < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathAllowAccessFilterFactory = @loader.const_get('RequestPathAllowAccessFilterFactory')
      @factory = @RequestPathAllowAccessFilterFactory.instance
    end

    def test_set_filter_option
      @factory.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RequestPathAllowAccess', @factory.filter_name)
    end

    def test_filter_args
      args = @factory.filter_args
      assert_equal('request path pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('request path pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('request path pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('request path pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('request path pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @factory.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RequestPathAllowAccessFilter'), filter)
    end
  end

  class TestRequestPathDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathDenyAccessFilter = @loader.const_get('RequestPathDenyAccessFilter')
      @access = @RequestPathDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_path(/foo/)
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_path(/foo/)
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/baz'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/baz', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRequestPathDenyAccessFilterFactory < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathDenyAccessFilterFactory = @loader.const_get('RequestPathDenyAccessFilterFactory')
      @factory = @RequestPathDenyAccessFilterFactory.instance
    end

    def test_set_filter_option
      @factory.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RequestPathDenyAccess', @factory.filter_name)
    end

    def test_filter_args
      args = @factory.filter_args
      assert_equal('request path pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('request path pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('request path pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('request path pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('request path pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end
  end
end
