#!/usr/local/bin/ruby
# $Id: test_SetupFilter.rb,v 1.2 2004/10/13 15:21:47 toki Exp $

require 'rubyunit'
require 'wpm'
require 'rucy/document'

module TestRucy
  class TestSetupFilter < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @params_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::DocumentFactory class
      @factory = Rucy::DocumentFactory.new
      erb = Object.new
      def erb.filter_name
	'eRuby'
      end
      def erb.filter_args
	[ [ 'safe level', :number, 1 ] ]
      end
      @factory.add_filter(erb)
      ssi = Object.new
      def ssi.filter_name
	'SSI'
      end
      def ssi.filter_args
	[ [ 'SSI commands', :checkset,
	    [ [ 'config',   true ],
	      [ 'include',  true ],
	      [ 'echo',     true ],
	      [ 'fsize',    true ],
	      [ 'flastmod', true ],
	      [ 'exec',     true ]
	    ]
	  ]
	]
      end
      @factory.add_filter(ssi)
      @filter_args_call = 0
      @filter_args_last_name = nil

      # for Rucy::Control class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @filter_list = [
	{ 'filter' => 'eRuby',
	  'arguments' => [ 1 ],
	  'attach_path' => '/eRuby',
	  'attach_mask' => %r/\.rhtml?/,
	  'virtual_host' => nil,
	  'comment' => 'test of eRuby'
	},
	{ 'filter' => 'SSI',
	  'arguments' => [
	    { 'config'   => true,
	      'include'  => true,
	      'echo'     => true,
	      'fsize'    => true,
	      'flastmod' => true,
	      'exec'     => false
	    }
	  ],
	  'attach_path' => '/~alice',
	  'attach_mask' => %r/\.shtml?/,
	  'virtual_host' => 'foo',
	  'comment' => 'test of SSI'
	}
      ]
      @filters_call = 0
      @set_filters_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/SetupFilter/SetupFilter.rb')
      @SetupFilter = loader.const_get('SetupFilter').new(self, { :control => self, :factory => self })
      assert((@SetupFilter.is_a? WPM::PageContext))
      @SetupFilter.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def params
      @params_call += 1
      { 'filter' => 'eRuby', 'pos' => '0' }
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def filter_args(filter_name)
      @filter_args_call += 1
      @filter_args_last_name = filter_name
      @factory.filter_args(filter_name)
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def filters
      @filters_call += 1
      filter_list = @filter_list.dup
      def filter_list.setup(parent)
	@parent = parent
	self
      end
      def filter_list.modified_count
	@parent.modified_count
      end
      def filter_list.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      filter_list.setup(self)
    end

    def set_filters(filter_list)
      @set_filters_call += 1
      @filter_list = filter_list
      nil
    end

    def test_reload_query
      assert_equal(1, @params_call)
      assert_equal({ 'filter' => 'eRuby', 'pos' => '0' }, @SetupFilter.reload_query)
    end

    def test_default_path
      assert_nil(@SetupFilter.default_path)
    end

    def test_default_mask_type
      assert_nil(@SetupFilter.default_mask_type)
    end

    def test_default_mask
      assert_nil(@SetupFilter.default_mask)
    end

    def test_default_virtual_host
      assert_nil(@SetupFilter.default_virtual_host)
    end

    def test_default_comment
      assert_nil(@SetupFilter.default_comment)
    end

    def test_document_factory
      assert_equal([ [ 'SSI commands', :checkset,
		       [ [ 'config',   true ],
			 [ 'include',  true ],
			 [ 'echo',     true ],
			 [ 'fsize',    true ],
			 [ 'flastmod', true ],
			 [ 'exec',     true ]
		       ]
		     ]
		   ], @SetupFilter.doc_args('SSI'))
      assert_equal(1, @filter_args_call)
      assert_equal('SSI', @filter_args_last_name)
    end

    def test_document
      assert_equal(1, @params_call)
      assert_equal('0', @SetupFilter.doc_pos)
      assert_equal('eRuby', @SetupFilter.doc_type)
    end

    def test_document_attributes
      assert_equal('filter', @SetupFilter.doc_tag)
      assert_equal('filter', @SetupFilter.doc_label)
      assert_equal('attach_path', @SetupFilter.path_tag)
      assert_equal('attach path', @SetupFilter.path_label)
      assert_equal('attach_mask', @SetupFilter.mask_tag)
      assert_equal('attach mask', @SetupFilter.mask_label)
    end

    def test_modified_count
      assert_equal(0, @SetupFilter.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal(1, @SetupFilter.modified_count = 1)
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_document_list
      filter_list = @SetupFilter.document_list
      assert_equal(1, @filters_call)
      assert_equal(2, filter_list.length)
      # 1
      assert_equal('eRuby', filter_list[0]['filter'])
      assert_equal('/eRuby', filter_list[0]['attach_path'])
      assert_equal(%r/\.rhtml?/, filter_list[0]['attach_mask'])
      assert_nil(filter_list[0]['virtual_host'])
      assert_equal('test of eRuby', filter_list[0]['comment'])
      assert_equal(1, filter_list[0]['arguments'].length)
      assert_equal(1, filter_list[0]['arguments'][0])
      # 2
      assert_equal('SSI', filter_list[1]['filter'])
      assert_equal('/~alice', filter_list[1]['attach_path'])
      assert_equal(%r/\.shtml?/, filter_list[1]['attach_mask'])
      assert_equal('foo', filter_list[1]['virtual_host'])
      assert_equal('test of SSI', filter_list[1]['comment'])
      assert_equal(1, filter_list[1]['arguments'].length)
      assert_equal({ 'config'   => true,
		     'include'  => true,
		     'echo'     => true,
		     'fsize'    => true,
		     'flastmod' => true,
		     'exec'     => false
		   }, filter_list[1]['arguments'][0])
    end

    def test_write_document_list
      @SetupFilter.write_document_list
      assert_equal(1, @set_filters_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('FilterMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_cancel
      @SetupFilter.cancel
      assert_equal(0, @set_filters_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('FilterMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end
  end
end

