#!/usr/local/bin/ruby
# $Id: test_Navigation.rb,v 1.4 2004/10/14 15:25:19 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestNavigation < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @set_header_call = 0
      @set_header_name = nil
      @set_header_value = nil

      # for Rucy::Control class
      @server_restart_call = 0
      @server_close_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/Navigation/Navigation.rb')
      @Navigation = loader.const_get('Navigation').new(self, { :control => self })
      assert((@Navigation.is_a? WPM::PageContext))
      @Navigation.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def set_header(name, value)
      @set_header_call += 1
      @set_header_name = name
      @set_header_value = value
      nil
    end

    def server_restart
      @server_restart_call += 1
      nil
    end

    def server_close
      @server_close_call += 1
      nil
    end

    def test_server_restart
      @Navigation.server_restart
      assert_equal(1, @driver_call)
      assert_equal(1, @set_header_call)	# driver -> set_header
      assert_equal('Connection', @set_header_name)
      assert_equal('close', @set_header_value)
      assert_equal(1, @server_restart_call)
    end

    def test_server_close
      @Navigation.server_close
      assert_equal(1, @driver_call)
      assert_equal(1, @set_header_call)	# driver -> set_header
      assert_equal('Connection', @set_header_name)
      assert_equal('close', @set_header_value)
      assert_equal(1, @server_close_call)
    end

    def test_ControlPanel
      @Navigation.page = 'ControlPanel'
      assert(@Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_MountMap
      @Navigation.page = 'MountMap'
      assert(! @Navigation.control_panel?)
      assert(@Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_SetupDocument
      @Navigation.page = 'SetupDocument'
      assert(! @Navigation.control_panel?)
      assert(@Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_FilterMap
      @Navigation.page = 'FilterMap'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(@Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_SetupFilter
      @Navigation.page = 'SetupFilter'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(@Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_AliasMap
      @Navigation.page = 'AliasMap'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(@Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_AliasMap
      @Navigation.page = 'SetupAlias'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(@Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_Logging
      @Navigation.page = 'Logging'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(@Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_AccessLog
      @Navigation.page = 'AccessLog'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(@Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_AddAccessLog
      @Navigation.page = 'AddAccessLog'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(@Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_AddLogFile
      @Navigation.page = 'AddLogFile'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(@Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_Error
      @Navigation.page = 'Error'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(@Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_Admininistrator
      @Navigation.page = 'Administrator'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(@Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_AdminPassword
      @Navigation.page = 'AdminPassword'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(@Navigation.administrator?)
      assert(! @Navigation.about?)
    end

    def test_About
      @Navigation.page = 'About'
      assert(! @Navigation.control_panel?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.mount_map?)
      assert(! @Navigation.filter_map?)
      assert(! @Navigation.alias_map?)
      assert(! @Navigation.logging?)
      assert(! @Navigation.access_log?)
      assert(! @Navigation.error?)
      assert(! @Navigation.administrator?)
      assert(@Navigation.about?)
    end

    def test_query
      assert_equal({}, @Navigation.query)
      @Navigation.query = { 'test' => 'HALO' }
      assert_equal({ 'test' => 'HALO' }, @Navigation.query)
    end

    def test_hidden_params
      assert(! @Navigation.has_hidden_params?)
      @Navigation.query = { 'foo' => 'Alice', 'bar' => 'Bob' }
      assert(@Navigation.has_hidden_params?)
      assert_equal('<input name="bar" type="hidden" value="Bob" />' +
		   '<input name="foo" type="hidden" value="Alice" />',
		   @Navigation.hidden_params)
    end
  end
end
