#!/usr/local/bin/ruby
# $Id: test_Logging.rb,v 1.3 2004/10/13 15:21:35 toki Exp $

require 'rubyunit'
require 'wpm'
require 'rucy/params'

module TestRucy
  class TestLogging < RUNIT::TestCase
    def setup
      # for Rucy::Control class
      @logging_params_call = 0
      @set_logging_params_call = 0
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @store = {
	'stdout_logging_level' => 'notice',
	'logfiles' => [
	  { 'path' => 'server.log', 'logging_level' => 'notice' },
	  { 'path' => 'access.log', 'logging_level' => 'info' },
	  { 'path' => 'debug.log', 'logging_level' => 'debug' }
	]
      }
      @stdout_logging_level_call = 0
      @set_stdout_logging_level_call = 0
      @logfiles_call = 0
      @del_logfile_at_call = 0
      @del_logfile_at_pos = nil

      # setup WPM::PageMaker class
      loader = WPM::Loader.new('../control/Logging/Logging.rb')
      @Logging = loader.const_get('Logging').new(self, { :control => self })
      assert((@Logging.is_a? WPM::PageContext))
      @Logging.init_context
    end

    def logging_params
      @logging_params_call += 1
      self
    end

    def set_logging_params(params)
      @set_logging_params_call += 1
      assert_equal(self, params)
      nil
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def stdout_logging_level
      @stdout_logging_level_call += 1
      @store['stdout_logging_level']
    end

    def stdout_logging_level=(new_level)
      @set_stdout_logging_level_call += 1
      @store['stdout_logging_level'] = new_level
    end

    def has_logfiles?
      @has_logfiles_call += 1
      ! @store['logfiles'].empty?
    end

    def logfiles
      @logfiles_call += 1
      @store['logfiles'].map{|attrs|
	Rucy::LoggingParams::LogFile.new(attrs)
      }
    end

    def del_logfile_at(pos)
      @del_logfile_at_call += 1
      @del_logfile_at_pos = pos
      @store['logfiles'].delete_at(pos)
      nil
    end

    def test_modified_count
      assert_equal(1, @logging_params_call)
      assert_equal(0, @Logging.modified_count)
      assert_equal(1, @modified_count_call)
      @Logging.modified_count = 1
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_stdout_logging_level
      assert_equal(1, @logging_params_call)
      assert_equal('notice', @Logging.stdout_logging_level)
      assert_equal(1, @stdout_logging_level_call)

      @Logging.stdout_logging_level = 'info'
      assert_equal(1, @set_stdout_logging_level_call)
      assert_equal('info', @store['stdout_logging_level'])

      @Logging.write_logging_parameter
      assert_equal(1, @set_logging_params_call)
    end

    def test_has_logfiles
      assert_equal(1, @logging_params_call)
      assert(@Logging.has_logfiles?)
      assert_equal(1, @logfiles_call)
    end

    def test_logfile_count
      assert_equal(1, @logging_params_call)
      assert_equal(3, @Logging.logfile_count)
      assert_equal(1, @logfiles_call)
    end

    def test_index
      @Logging.index = 1
      assert_equal(1, @Logging.index)
    end

    def test_logfile
      assert_equal(1, @logging_params_call)
      @Logging.call_index = 0
      assert_equal('server.log', @Logging.logfile_path)
      assert_equal(1, @logfiles_call)
      assert_equal('notice', @Logging.logfile_logging_level)
      assert_equal(2, @logfiles_call)
      @Logging.call_index = 1
      assert_equal('access.log', @Logging.logfile_path)
      assert_equal(3, @logfiles_call)
      assert_equal('info', @Logging.logfile_logging_level)
      assert_equal(4, @logfiles_call)
      @Logging.call_index = 2
      assert_equal('debug.log', @Logging.logfile_path)
      assert_equal(5, @logfiles_call)
      assert_equal('debug', @Logging.logfile_logging_level)
      assert_equal(6, @logfiles_call)

      @Logging.call_index = 1
      @Logging.logfile_path = 'error.log'
      assert_equal(7, @logfiles_call)
      assert_equal('error.log', @Logging.logfile_path)
      assert_equal(8, @logfiles_call)
      @Logging.logfile_logging_level = 'err'
      assert_equal(9, @logfiles_call)
      assert_equal('err', @Logging.logfile_logging_level)
      assert_equal(10, @logfiles_call)

      @Logging.write_logging_parameter
      assert_equal(1, @set_logging_params_call)
      assert_equal(3, @store['logfiles'].length)
      assert_equal('server.log', @store['logfiles'][0]['path'])
      assert_equal('notice', @store['logfiles'][0]['logging_level'])
      assert_equal('error.log', @store['logfiles'][1]['path'])
      assert_equal('err', @store['logfiles'][1]['logging_level'])
      assert_equal('debug.log', @store['logfiles'][2]['path'])
      assert_equal('debug', @store['logfiles'][2]['logging_level'])
    end

    def test_logfile_delete
      assert_equal(1, @logging_params_call)
      @Logging.call_index = 2
      @Logging.logfile_delete
      assert_equal(1, @del_logfile_at_call)
      assert_equal(2, @del_logfile_at_pos)
      assert_equal(1, @set_logging_params_call)
      assert_equal(2, @store['logfiles'].length)
      assert_equal('server.log', @store['logfiles'][0]['path'])
      assert_equal('notice', @store['logfiles'][0]['logging_level'])
      assert_equal('access.log', @store['logfiles'][1]['path'])
      assert_equal('info', @store['logfiles'][1]['logging_level'])
    end
  end
end
