#!/usr/local/bin/ruby
# $Id: test_AliasMap.rb,v 1.3 2004/10/13 15:21:18 toki Exp $

require 'rubyunit'
require 'wpm'

# patch for new data structure: Rucy::AliasList class (lib_ctrl/rucy/params.rb)
class Array
  def swap(i, j)
    self[i], self[j] = self[j], self[i]
    nil
  end
end

module TestRucy
  class TestAliasMap < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::Control
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_last_value = nil
      @aliases_call = 0
      @set_aliases_call = 0
      @alias_list = [
	{ 'alias_path' => '/bar',
	  'orig_path' => '/foo',
	  'virtual_host' => nil
	},
	{ 'alias_path' => '/fuge',
	  'orig_path' => '/hoge',
	  'virtual_host' => 'www2'
	}
      ]

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/AliasMap/AliasMap.rb')
      @AliasMap = loader.const_get('AliasMap').new(self, { :control => self })
      assert((@AliasMap.is_a? WPM::PageContext))
      @AliasMap.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_last_value = modified_count
    end

    def aliases
      @aliases_call += 1
      alias_list = @alias_list.dup
      def alias_list.setup(parent)
	@parent = parent
	self
      end
      def alias_list.modified_count
	@parent.modified_count
      end
      def alias_list.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      alias_list.setup(self)
    end

    def set_aliases(alias_list)
      @set_aliases_call += 1
      @alias_list = alias_list
      nil
    end

    def test_modified_count
      assert_equal('0', @AliasMap.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal('1', @AliasMap.modified_count = '1')
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_last_value)
    end

    def test_has_aliases?
      assert(@AliasMap.has_aliases?)
      assert_equal(1, @aliases_call)
    end

    def test_alias_list
      alias_list = @AliasMap.alias_list
      assert_equal(1, @aliases_call)
      assert_equal(2, alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, alias_list[1])
    end

    def test_alias
      @AliasMap.alias = {
	'alias_path' => '/bar',
	'orig_path' => '/foo',
	'virtual_host' => 'www'
      }
      assert_equal('/bar', @AliasMap.alias_path)
      assert_equal('/foo', @AliasMap.orig_path)
      assert_equal('www', @AliasMap.virtual_host)
    end

    def test_alias_index
      @AliasMap.alias_index = 1
      assert_equal(1, @AliasMap.alias_index)
    end

    def test_entry_up_disabled?
      assert_equal(1, @aliases_call)
      @AliasMap.entry_up_call_index = 0
      assert(@AliasMap.entry_up_disabled?)
      @AliasMap.entry_up_call_index = 1
      assert(! @AliasMap.entry_up_disabled?)
      @AliasMap.entry_up_call_index = 2
      assert(@AliasMap.entry_up_disabled?)
    end

    def test_entry_up
      assert_equal(1, @aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[1])

      @AliasMap.entry_up_call_index = 0
      @AliasMap.entry_up
      assert_equal(0, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[1])

      @AliasMap.entry_up_call_index = 1
      @AliasMap.entry_up
      assert_equal(1, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[1])
    end

    def test_entry_down_disabled?
      assert_equal(1, @aliases_call)
      @AliasMap.entry_down_call_index = 0
      assert(! @AliasMap.entry_down_disabled?)
      @AliasMap.entry_down_call_index = 1
      assert(@AliasMap.entry_down_disabled?)
      @AliasMap.entry_down_call_index = 2
      assert(@AliasMap.entry_down_disabled?)
    end

    def test_entry_down
      assert_equal(1, @aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[1])

      @AliasMap.entry_down_call_index = 1
      @AliasMap.entry_down
      assert_equal(0, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[1])

      @AliasMap.entry_down_call_index = 0
      @AliasMap.entry_down
      assert_equal(1, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[1])
    end

    def test_edit_alias
      @AliasMap.edit_alias_call_index = 1
      @AliasMap.edit_alias
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('SetupAlias', @redirect_last_page_name)
      assert_equal({ 'pos' => '1' }, @redirect_last_query_params)
    end

    def test_add_alias
      @AliasMap.add_alias
      assert_equal(1, @aliases_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('SetupAlias', @redirect_last_page_name)
      assert_equal({ 'pos' => '2' }, @redirect_last_query_params)
    end

    def test_del_alias
      @AliasMap.del_alias_call_index = 0
      @AliasMap.del_alias
      assert_equal(1, @set_aliases_call)
      assert_equal(1, @alias_list.length)
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[0])
    end
  end
end
