#!/usr/local/bin/ruby
# $Id: test_Administrator.rb,v 1.5 2004/10/13 15:21:15 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestAdministrator < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::Control class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @store = {
	'admin_user' => 'admin',
	'admin_password' => 'nazo',
	'localhost_only' => true,
	'japanese_handling' => false
      }
      @admin_params_call = 0
      @set_admin_params_call = 0
      @admin_user_call = 0
      @admin_password_call = 0
      @localhost_only_call = 0
      @set_localhost_only_call = 0
      @japanese_handling_call = 0
      @set_japanese_handling_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/Administrator/Administrator.rb')
      @Administrator = loader.const_get('Administrator').new(self, { :control => self })
      assert((@Administrator.is_a? WPM::PageContext))
      @Administrator.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def admin_params
      @admin_params_call += 1
      self
    end

    def set_admin_params(params)
      @set_admin_params_call += 1
      assert_equal(self, params)
      nil
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def admin_user
      @admin_user_call += 1
      @store['admin_user']
    end

    def admin_password
      @admin_password_call += 1
      @store['admin_password']
    end

    def localhost_only
      @localhost_only_call += 1
      @store['localhost_only']
    end

    def localhost_only=(boolean)
      @set_localhost_only_call += 1
      @store['localhost_only'] = boolean
    end

    def japanese_handling
      @japanese_handling_call += 1
      @store['japanese_handling']
    end

    def japanese_handling=(boolean)
      @set_japanese_handling_call += 1
      @store['japanese_handling'] = boolean
    end

    def test_modified_count
      assert_equal(1, @admin_params_call)
      assert_equal(0, @Administrator.modified_count)
      assert_equal(1, @modified_count_call)
      @Administrator.modified_count = 1
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_username
      assert_equal(1, @admin_params_call)
      assert_equal('admin', @Administrator.username)
      assert_equal(1, @admin_user_call)
    end

    def test_password
      assert_equal(1, @admin_params_call)
      assert_equal('nazo', @Administrator.password)
      assert_equal(1, @admin_password_call)
    end

    def test_empty_password?
      assert_equal(1, @admin_params_call)
      assert(! @Administrator.empty_password?)
      assert_equal(1, @admin_password_call)
    end

    def test_edit_user
      @Administrator.edit_user
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AdminPassword', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_localhost_only
      assert_equal(1, @admin_params_call)
      assert_equal(true, @Administrator.localhost_only)
      assert_equal(1, @localhost_only_call)
      @Administrator.localhost_only = false
      assert_equal(1, @set_localhost_only_call)
      assert_equal(false, @store['localhost_only'])
      @Administrator.commit
      assert_equal(1, @set_admin_params_call)
    end

    def test_japanese_handling
      assert_equal(1, @admin_params_call)
      assert_equal(false, @Administrator.japanese_handling)
      assert_equal(1, @japanese_handling_call)
      @Administrator.japanese_handling = true
      assert_equal(1, @set_japanese_handling_call)
      assert_equal(true, @store['japanese_handling'])
      @Administrator.commit
      assert_equal(1, @set_admin_params_call)
    end
  end
end
