#!/usr/local/bin/ruby

require 'rubyunit'
require 'wpm'
require 'pseudo_props'
require 'rucy/params'
require 'rucy/logger'

module TestRucy
  class TestAddAccessLog < RUNIT::TestCase
    include PseudoProperties

    def setup
      super

      # for WPM::Driver class
      @driver_call = 0
      @redirect_call = 0
      @redirect_page_name = nil
      @redirect_query_params = nil

      # for Rucy::Control class
      @access_log_params = Rucy::AccessLogParams.new
      @access_log_params_call = 0
      @set_access_log_params_call = 0

      # for Rucy::AccessLogParams class
      @store['access_logs'] = [
	{ 'path' => 'foo.log', 'format' => 'foo' },
	{ 'path' => 'bar.log', 'format' => 'bar' }
      ]
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = 0
      @add_logfile_call = 0
      @logfiles_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/AddAccessLog/AddAccessLog.rb')
      @AddAccessLog = loader.const_get('AddAccessLog').new(self, { :control => self })
      assert((@AddAccessLog.is_a? WPM::PageContext))
      @AddAccessLog.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_page_name = page_name
      @redirect_query_params = query_params
      nil
    end

    def access_log_params
      @access_log_params_call += 1
      @access_log_params.load(self)
      self
    end

    def set_access_log_params(params)
      @set_access_log_params_call += 1
      assert_equal(self, params)
      @access_log_params.save(self)
      self
    end

    def modified_count
      @modified_count_call += 1
      @access_log_params.modified_count
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
      @access_log_params.modified_count = new_count
    end

    def add_logfile
      @add_logfile_call += 1
      @access_log_params.add_logfile
      nil
    end

    def logfiles
      @logfiles_call += 1
      @access_log_params.logfiles
    end

    def test_modified_count
      assert_equal(1, @access_log_params_call)
      assert_equal(0, @AddAccessLog.modified_count)
      assert_equal(1, @modified_count_call)
      @AddAccessLog.modified_count = 1
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_index
      assert_equal(1, @access_log_params_call)
      assert_equal(1, @add_logfile_call)
      assert_equal(3, @AddAccessLog.index)
      assert_equal(1, @logfiles_call)
    end

    def test_logfile
      assert_equal(1, @access_log_params_call)
      assert_equal(1, @add_logfile_call)
      assert_equal(nil, @AddAccessLog.path)
      assert_equal(1, @logfiles_call)
      assert_equal(Rucy::AccessLog::COMMON_LOG_FORMAT, @AddAccessLog.format)
      assert_equal(2, @logfiles_call)

      @AddAccessLog.path = 'baz.log'
      assert_equal(3, @logfiles_call)
      assert_equal('baz.log', @AddAccessLog.path)
      assert_equal(4, @logfiles_call)
      @AddAccessLog.format = 'baz'
      assert_equal(5, @logfiles_call)
      assert_equal('baz', @AddAccessLog.format)

      @AddAccessLog.write
      assert_equal(1, @set_access_log_params_call)
      assert_equal(3, @store['access_logs'].length)
      assert_equal({ 'path' => 'foo.log', 'format' => 'foo' }, @store['access_logs'][0])
      assert_equal({ 'path' => 'bar.log', 'format' => 'bar' }, @store['access_logs'][1])
      assert_equal({ 'path' => 'baz.log', 'format' => 'baz' }, @store['access_logs'][2])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AccessLog', @redirect_page_name)
      assert_equal(nil, @redirect_query_params)
    end

    def test_return
      assert_equal(1, @access_log_params_call)
      assert_equal(1, @add_logfile_call)
      @AddAccessLog.return
      assert_equal(0, @set_access_log_params_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AccessLog', @redirect_page_name)
    end
  end
end
