# $Id: pseudo_req_res.rb,v 1.3 2004/09/23 13:18:25 toki Exp $

require 'rucy/logger'
require 'rucy/request'
require 'rucy/response'

module TestRucy
  module PseudoLogger
    include Rucy::LoggingLevel

    def setup
      super
      @log_emerg = ''
      @log_alert = ''
      @log_crit = ''
      @log_err = ''
      @log_warning = ''
      @log_notice = ''
      @log_info = ''
      @log_debug = ''
      @logger = self
    end

    def messg(level, messg, format=true)
      case (level)
      when LOG_EMERG
	@log_emerg << messg << "\n"
      when LOG_ALERT
	@log_alert << messg << "\n"
      when LOG_CRIT
	@log_crit << messg << "\n"
      when LOG_ERR
	@log_err << messg << "\n"
      when LOG_WARNING
	@log_warning << messg << "\n"
      when LOG_NOTICE
	@log_notice << messg << "\n"
      when LOG_INFO
	@log_info << messg << "\n"
      when LOG_DEBUG
	@log_debug << messg << "\n"
      else
	assert_fail("unknown logging level: #{level.inspect}")
      end
      nil
    end
  end

  module PseudoRequestResponse
    def setup
      super
      @request = Rucy::Request.new
      @request.set_server('server', '192.168.0.1', 8080)
      @request.set_client('client', '192.168.0.2', 31415)
      @response = Rucy::Response.new
      @messg_head = nil
      @messg_body = ''
      @response.set_writer(self)
    end

    def write_head(response)
      if (@messg_head) then
	raise 'duplicated header'
      else
	@messg_head = response
      end

      nil
    end

    def write(messg_body)
      if (@messg_head) then
	@messg_body << messg_body
      else
	raise 'no header'
      end

      nil
    end

    def <<(other)
      write(other.to_s)
      nil
    end
  end

  module PseudoDocument
    def setup
      super
      @each_call = 0
      @publish_call = 0
      @publish_script_name = nil
      @publish_request_path = nil
      @publish_doc_path = nil
      @publish_local_path = nil
      @publish_content_type = 'text/plain'
      @publish_messg_body = 'foo'
    end

    def each(traversed={})
      unless (traversed.include? self) then
	@each_call += 1
	yield(self)
      end
      nil
    end

    def publish(script_name, request, response, logger)
      @publish_call += 1
      @publish_script_name = script_name
      @publish_request_path = request.path
      response.doc_path = @publish_doc_path if @publish_doc_path
      response.local_path = @publish_local_path if @publish_local_path
      logger.debug('pseudo publish.')
      response.status = 200
      response.set_header('Content-Type', @publish_content_type)
      response.start_body
      response << @publish_messg_body if (request.method != 'HEAD')
      nil
    end
  end

  module PseudoFilter
    def setup
      super
      @init_call = 0
      @final_call = 0
      @filter_open_call = 0
      @filter_head_call = 0
      @filter_body_call = 0
      @filter_close_call = 0
      @filter_script_name = nil
      @filter_request_path = nil
    end

    def init
      @init_call += 1
      nil
    end

    def final
      @final_call += 1
      nil
    end

    def filter_open(context, script_name, request, response, logger)
      @filter_open_call += 1
      @filter_script_name = script_name
      @filter_request_path = request.path
      logger.debug('pseudo filter_open.')
      nil
    end

    def filter_head(context, script_name, request, response, logger)
      @filter_head_call += 1
      logger.debug('pseudo filter_head.')
      response.start_body
      nil
    end

    def filter_body(context, script_name, request, response, logger, messg_body)
      @filter_body_call += 1
      logger.debug('pseudo filter_body.')
      response.write(messg_body)
      nil
    end

    def filter_close(context, script_name, request, response, logger)
      @filter_close_call += 1
      logger.debug('pseudo filter_close.')
      nil
    end
  end
end
