# $Id: access.rb,v 1.1 2004/09/29 13:24:58 toki Exp $

require 'singleton'
require 'rucy/error'
require 'rucy/document'

include Rucy

class RemoteAddressAllowAccessFilter < Filter
  def initialize
    @allow_cond_list = Array.new
  end

  def add_allow_address(addr_cond)
    @allow_cond_list.push(addr_cond)
    nil
  end

  def filter_open(context, script_name, request, response, logger)
    for addr_cond in @allow_cond_list
      if (addr_cond === request.client_address) then
	return
      end
    end
    raise HTTPError.new(403)	# Forbidden
  end
end

class RemoteAddressAllowAccessFilterFactory
  include Singleton

  NARGS = 5

  def set_filter_option(option)
  end

  def filter_name
    'RemoteAddressAllowAccess'
  end

  def filter_args
    args = Array.new
    for i in 1..NARGS
      args.push([ "remote address pattern #{i} (regexp)", :regexp, nil ])
    end
    args
  end

  def new(*args)
    access = RemoteAddressAllowAccessFilter.new
    NARGS.times do
      addr_pat = args.shift
      if (addr_pat && ! addr_pat.source.empty?) then
	access.add_allow_address(addr_pat)
      end
    end
    access
  end
end

class RemoteAddressDenyAccessFilter < Filter
  def initialize
    @deny_cond_list = Array.new
  end

  def add_deny_address(addr_cond)
    @deny_cond_list.push(addr_cond)
    nil
  end

  def filter_open(context, script_name, request, response, logger)
    for addr_cond in @deny_cond_list
      if (addr_cond === request.client_address) then
	raise HTTPError.new(403) # Forbidden
      end
    end
    nil
  end
end

class RemoteAddressDenyAccessFilterFactory
  include Singleton

  NARGS = 5

  def set_filter_option(option)
  end

  def filter_name
    'RemoteAddressDenyAccess'
  end

  def filter_args
    args = Array.new
    for i in 1..NARGS
      args.push([ "remote address pattern #{i} (regexp)", :regexp, nil ])
    end
    args
  end

  def new(*args)
    access = RemoteAddressDenyAccessFilter.new
    NARGS.times do
      addr_pat = args.shift
      if (addr_pat && ! addr_pat.source.empty?) then
	access.add_deny_address(addr_pat)
      end
    end
    access
  end
end

class RemoteHostAllowAccessFilter < Filter
  def initialize
    @allow_cond_list = Array.new
  end

  def add_allow_name(name_cond)
    @allow_cond_list.push(name_cond)
    nil
  end

  def filter_open(context, script_name, request, response, logger)
    for name_cond in @allow_cond_list
      if (name_cond === request.client_name) then
	return
      end
    end
    raise HTTPError.new(403)	# Forbidden
  end
end

class RemoteHostAllowAccessFilterFactory
  include Singleton

  NARGS = 5

  def set_filter_option(option)
  end

  def filter_name
    'RemoteHostAllowAccess'
  end

  def filter_args
    args = Array.new
    for i in 1..NARGS
      args.push([ "remote host name pattern #{i} (regexp)", :regexp, nil ])
    end
    args
  end

  def new(*args)
    access = RemoteHostAllowAccessFilter.new
    NARGS.times do
      name_pat = args.shift
      if (name_pat && ! name_pat.source.empty?) then
	access.add_allow_name(name_pat)
      end
    end
    access
  end
end

class RemoteHostDenyAccessFilter < Filter
  def initialize
    @deny_cond_list = Array.new
  end

  def add_deny_name(name_cond)
    @deny_cond_list.push(name_cond)
    nil
  end

  def filter_open(context, script_name, request, response, logger)
    for name_cond in @deny_cond_list
      if (name_cond === request.client_name) then
	raise HTTPError.new(403) # Forbidden
      end
    end
    nil
  end
end

class RemoteHostDenyAccessFilterFactory
  include Singleton

  NARGS = 5

  def set_filter_option(option)
  end

  def filter_name
    'RemoteHostDenyAccess'
  end

  def filter_args
    args = Array.new
    for i in 1..NARGS
      args.push([ "remote host name pattern #{i} (regexp)", :regexp, nil ])
    end
    args
  end

  def new(*args)
    access = RemoteHostDenyAccessFilter.new
    NARGS.times do
      name_pat = args.shift
      if (name_pat && ! name_pat.source.empty?) then
	access.add_deny_name(name_pat)
      end
    end
    access
  end
end

class RequestPathAllowAccessFilter < Filter
  def initialize
    @allow_cond_list = Array.new
  end

  def add_allow_path(addr_cond)
    @allow_cond_list.push(addr_cond)
    nil
  end

  def filter_open(context, script_name, request, response, logger)
    for addr_cond in @allow_cond_list
      if (addr_cond === request.path) then
	return
      end
    end
    raise HTTPError.new(403)	# Forbidden
  end
end

class RequestPathAllowAccessFilterFactory
  include Singleton

  NARGS = 5

  def set_filter_option(option)
  end

  def filter_name
    'RequestPathAllowAccess'
  end

  def filter_args
    args = Array.new
    for i in 1..NARGS
      args.push([ "request path pattern #{i} (regexp)", :regexp, nil ])
    end
    args
  end

  def new(*args)
    access = RequestPathAllowAccessFilter.new
    NARGS.times do
      addr_pat = args.shift
      if (addr_pat && ! addr_pat.source.empty?) then
	access.add_allow_path(addr_pat)
      end
    end
    access
  end
end

class RequestPathDenyAccessFilter < Filter
  def initialize
    @deny_cond_list = Array.new
  end

  def add_deny_path(addr_cond)
    @deny_cond_list.push(addr_cond)
    nil
  end

  def filter_open(context, script_name, request, response, logger)
    for addr_cond in @deny_cond_list
      if (addr_cond === request.path) then
	raise HTTPError.new(403) # Forbidden
      end
    end
    nil
  end
end

class RequestPathDenyAccessFilterFactory
  include Singleton

  NARGS = 5

  def set_filter_option(option)
  end

  def filter_name
    'RequestPathDenyAccess'
  end

  def filter_args
    args = Array.new
    for i in 1..NARGS
      args.push([ "request path pattern #{i} (regexp)", :regexp, nil ])
    end
    args
  end

  def new(*args)
    access = RequestPathDenyAccessFilter.new
    NARGS.times do
      addr_pat = args.shift
      if (addr_pat && ! addr_pat.source.empty?) then
	access.add_deny_path(addr_pat)
      end
    end
    access
  end
end
