# $Id: xmlparser.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $
# -
# XML handler by XMLParser

# Usage
# -
# require 'pm'
# require 'pm/xmlparser'
# xml_reader = WPM::XMLReader.new
# xml_reader.extend(WPM::XMLAssistByXMLParser)
# xml_reader.read(__input_stream__)

require 'xmlparser'

module WPM
  class XMLHandlerByXMLParser < XMLParser
    def init(reader)
      @reader = reader
      @ns_map = XMLNamespaceMap.new
      @ns_map.start_element
      nil
    end

    def final
      @reader = nil
      @ns_map.end_element
      @ns_map = nil
      done
      nil
    end

    def startElement(name, attrs)
      @ns_map.start_element

      for attr_name, attr_value in attrs
	case (attr_name)
	when /^xmlns($|:)/
	  xmlns, prefix = attr_name.split(/:/, 2)
	  prefix = '' unless prefix
	  ns_uri = attr_value
	  @ns_map.add_ns(prefix, ns_uri)
	else
	  # nothing to do.
	end
      end

      attr_map = XMLAttributeMap.new
      for attr_name, attr_value in attrs
	case (attr_name)
	when /^xmlns($|:)/
	  # nothing to do.
	else
	  if (attr_name =~ /:/) then
	    prefix, ns_attr_name = attr_name.split(/:/, 2)
	    unless (@ns_map[prefix]) then
	      raise "not defined a XML namespace prefix: #{prefix.inspect}"
	    end
	    attr_map.add_attr(@ns_map[prefix], prefix, ns_attr_name, attr_value)
	  else
	    attr_map.add_attr('', '', attr_name, attr_value)
	  end
	end
      end

      if (name =~ /:/) then
	prefix, elem_name = name.split(/:/, 2)
      else
	prefix = ''
	elem_name = name
      end
      unless (@ns_map[prefix]) then
	raise "not defined a XML namespace prefix: #{prefix.inspect}"
      end
      @reader.start_element(@ns_map[prefix], prefix, elem_name, attr_map)
    end

    def endElement(name)
      if (name =~ /:/) then
	prefix, elem_name = name.split(/:/, 2)
      else
	prefix = ''
	elem_name = name
      end
      @reader.end_element(@ns_map[prefix], prefix, elem_name)

      @ns_map.end_element
    end

    def processingInstruction(target, data)
      @reader.processing_instruction(target, data)
    end

    def character(data)
      @reader.character(data)
    end

    def comment(data)
      @reader.comment(data)
    end
  end

  module XMLAssistByXMLParser
    def read(input)
      handler = XMLHandlerByXMLParser.new
      handler.init(self)
      handler.parse(input)
      handler.final
      nil
    end
  end
end
