# $Id: rexml.rb,v 1.3 2004/10/17 14:20:28 toki Exp $
# -
# XML handler by REXML

# Usage
# -
# require 'pm'
# require 'pm/rexml'
# xml_reader = WPM::XMLReader.new
# xml_reader.extend(WPM::XMLAssistByREXML)
# xml_reader.read(__input_stream__)

require 'rexml/document'
require 'rexml/streamlistener'

module WPM
  class XMLHandlerByREXML
    include REXML::StreamListener

    def initialize(reader)
      @reader = reader
      @ns_map = XMLNamespaceMap.new
      @ns_map.start_element
      @depth = 0
      @end_of_body = false
    end

    def tag_start(name, attrs)
      @depth += 1
      @ns_map.start_element

      for attr_name, attr_value in attrs
	case (attr_name)
	when /^xmlns($|:)/
	  xmlns, prefix = attr_name.split(/:/, 2)
	  prefix = '' unless prefix
	  ns_uri = attr_value
	  @ns_map.add_ns(prefix, ns_uri)
	else
	  # nothing to do.
	end
      end

      attr_map = XMLAttributeMap.new
      for attr_name, attr_value in attrs
	case (attr_name)
	when /^xmlns($|:)/
	  # nothing to do.
	else
	  if (attr_name =~ /:/) then
	    prefix, ns_attr_name = attr_name.split(/:/, 2)
	    unless (@ns_map[prefix]) then
	      raise "not defined a XML namespace prefix: #{prefix.inspect}"
	    end
	    attr_map.add_attr(@ns_map[prefix], prefix, ns_attr_name, attr_value)
	  else
	    attr_map.add_attr('', '', attr_name, attr_value)
	  end
	end
      end

      if (name =~ /:/) then
	prefix, elem_name = name.split(/:/, 2)
      else
	prefix = ''
	elem_name = name
      end
      unless (@ns_map[prefix]) then
	raise "not defined a XML namespace prefix: #{prefix.inspect}"
      end
      @reader.start_element(@ns_map[prefix], prefix, elem_name, attr_map)
    end

    def tag_end(name)
      if (name =~ /:/) then
	prefix, elem_name = name.split(/:/, 2)
      else
	prefix = ''
	elem_name = name
      end
      @reader.end_element(@ns_map[prefix], prefix, elem_name)

      @ns_map.end_element
      @depth -= 1
      @end_of_body = true if (@depth == 0)
    end

    def instruction(target, data)
      @reader.processing_instruction(target, data)
    end

    def text(data)
      @reader.character(data) unless @end_of_body
    end

    def comment(data)
      @reader.comment(data)
    end
  end

  module XMLAssistByREXML
    def read(input)
      handler = XMLHandlerByREXML.new(self)
      REXML::Document.parse_stream(input, handler)
      nil
    end
  end
end
