# $Id: cgidriver.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $
# -
# HTTP message driver for cgi.rb

require 'cgi'

module WPM
  class CGIDriver < Driver
    def initialize
      @cgi = CGI.new
      @options = Hash.new
      @messg_body = ''
      @closed = false
    end

    def handler
      @closed and raise 'closed'
      @cgi
    end

    def env
      @closed and raise 'closed'
      ENV
    end

    def params
      @closed and raise 'closed'

      params = Hash.new
      for name in @cgi.keys
	params[name] = @cgi[name].first.to_s
      end

      params
    end

    def header(name)
      @closed and raise 'closed'

      case (name)
      when /^Content-Type$/i
	content_type = @options['type']
	content_type += '; charset=' + @options['charset'] if (@options.include? 'charset')
	return content_type
      when /^Status$/i
	return @options['status']
      when /^Server$/i
	return @options['server']
      when /^Connection$/i
	return @options['connection']
      when /^Content-Length$/i
	return @options['length']
      when /^Content-Language$/i
	return @options['language']
      when /^Expires$/i
	return @options['expires']
      when /^Set-Cookie$/i
	return @options['cookie']
      else
	return @options[name]
      end
    end

    def set_header(name, value)
      @closed and raise 'closed'

      case (name)
      when /^Content-Type$/i
	if (value =~ %r"^\S+/\S+") then
	  @options['type'] = $&
	  @options['type'].gsub!(/;$/, '')
	end
	if (value =~ %r'charset="([^"]+)"' || value =~ %r"charset=(\S+)") then
	  @options['charset'] = $1
	end
      when /^Status$/i
	@options['status'] = value
      when /^Server$/i
	@options['server'] = value
      when /^Connection$/i
	@options['connection'] = value
      when /^Content-Length$/i
	@options['length'] = value
      when /^Content-Language$/i
	@options['language'] = value
      when /^Expires$/i
	@options['expires'] = value
      when /^Set-Cookie$/i
	@options['cookie'] = value
      else
	@options[name] = value
      end

      nil
    end

    def write(messg_body)
      @closed and raise 'closed'
      @messg_body.concat(messg_body)
      nil
    end

    def close
      @closed and raise 'closed'
      @closed = true
      @cgi.out(@options) { @messg_body }
      nil
    end
  end
end
