# $Id: response.rb,v 1.4 2004/09/23 14:32:08 toki Exp $

require 'rucy/error'
require 'rucy/status'
require 'rucy/message'

module Rucy
  class Response < Message
    def initialize
      super
      @version = 'HTTP/1.1'
      @status = nil
      @reason = nil
      @doc_path = nil
      @local_path = nil
      @closed_head = false
      @messg_writer = nil

      self.status = 200
    end

    attr_accessor :version
    attr_reader   :status
    attr_accessor :reason
    attr_accessor :doc_path
    attr_accessor :local_path

    def status=(code)
      @status = code
      @reason = HTTP_STAT[code] || 'Unknown'
      code
    end

    def line
      "#{@version || '-'} #{@status || '-'} #{@reason || '-'}"
    end

    def parse_status
      if (has_header? 'Location') then
	self.status = 302	# Found
      end

      if (value = header('Status')) then
	status, reason = value.split(/\s+/, 2)
	if (status.nil? || status.empty? || reason.nil? || reason.empty?) then
	  raise ParseError, "failed to parse a status header: #{header('Status').inspect}"
	end

	if (status =~ /^\d\d\d$/) then
	  @status = status.to_i
	else
	  raise ParseError, "invalid status code format: #{header('Status').inspect}"
	end
	@reason = reason

	delete_header('Status')
      end

      nil
    end

    def parse_line(input)
      for line in input
	line.chomp!("\n")
	line.chomp!("\r")
	next if line.empty?

	version, status, reason = line.split(/\s+/, 3)
	if (version.nil? || version.empty?) then
	  raise ParseError, "failed to parse a status line: #{line.inspect}"
	end
	if (status.nil? || status.empty?) then
	  raise ParseError, "failed to parse a status line: #{line.inspect}"
	end
	if (reason.nil? || reason.empty?) then
	  raise ParseError, "failed to parse a status line: #{line.inspect}"
	end

	if (version =~ %r"^HTTP/\d+\.\d+$") then
	  @version = version
	else
	  raise ParseError, "invalid HTTP version format: #{line.inspect}"
	end
	if (status =~ /^\d\d\d$/) then
	  @status = status.to_i
	else
	  raise ParseError, "invalid status code format: #{line.inspect}"
	end
	@reason = reason

	break
      end

      nil
    end

    def parse(input)
      parse_line(input)
      parse_header(input)
      nil
    end

    def conn_closed?
      case (@version)
      when 'HTTP/1.1', 'HTTP/1.0'
	if (header('Connection') =~ /close/i) then
	  return true
	else
	  return false
	end
      else
	return true
      end
    end

    def conn_close
      if (! headers('Connection').find{|v| v =~ /close/i }) then
	set_header('Connection', 'close', true)
      end
      delete_header_if('Connection') {|value| value =~ /Keep-Alive/i }
      delete_header('Keep-Alive')

      nil
    end

    def conn_keep_alive(req_version)
      case (req_version)
      when 'HTTP/1.1'
	delete_header_if('Connection') {|value| value =~ /close/i }
      when 'HTTP/1.0'
	if (has_header? 'Content-Length') then
	  delete_header_if('Connection') {|value| value =~ /close/i }
	  if (! headers('Connection').find{|v| v =~ /Keep-Alive/i }) then
	    set_header('Connection', 'Keep-Alive', true)
	  end
	else
	  conn_close
	end
      else
	conn_close
      end

      nil
    end

    def absolute_location(request)
      if (uri = header('Location')) then
	if (uri =~ %r"^/") then
	  abs_uri = 'http://'
	  abs_uri << request.host << uri
	  set_header('Location', abs_uri)
	end
      end
      nil
    end

    def set_writer(output)
      @closed_head and raise 'closed message head'
      @messg_writer = output
      nil
    end

    def closed_head?
      @closed_head
    end

    def start_body
      @closed_head and raise 'closed message head'
      @messg_writer.write_head(self)
      @closed_head = true
      nil
    end

    def write(messg_body)
      @closed_head or raise 'not closed messasge head'
      @messg_writer.write(messg_body)
      nil
    end

    def <<(messg_body)
      write(messg_body.to_s)
      self
    end

    def send_size
      @messg_writer.send_size
    end
  end
end
