# $Id: message.rb,v 1.2 2004/04/06 22:09:24 toki Exp $

require 'rucy/cache'
require 'rucy/error'

module Rucy
  class Message
    IRREG_WORD = {
      'WWW'  => 'WWW',
      'ETAG' => 'ETag',
      'MD5'  => 'MD5',
      'TE'   => 'TE',
      'HTTP' => 'HTTP',
      'URL'  => 'URL',
      'URI'  => 'URI'
    }

    HEADER_NAME = ImmutableObjectCache.new{ |name|
      segments = name.split(/-/)
      segments.map!{ |word|
	IRREG_WORD[word.upcase] || word.capitalize
      }
      segments.join('-')
    }

    def self.normalize_header(name)
      HEADER_NAME[name]
    end

    def initialize
      @header = Hash.new
    end

    def header(name, pos=0)
      normalized_name = Message.normalize_header(name)
      if (value_list = @header[normalized_name]) then
	return value_list[pos]
      end

      nil
    end

    def headers(name)
      normalized_name = Message.normalize_header(name)
      @header[normalized_name] || Array.new
    end

    def set_header(name, value, append=false)
      normalized_name = Message.normalize_header(name)
      if (value_list = @header[normalized_name]) then
	if (append) then
	  value_list.push(value)
	else
	  value_list[0] = value
	end
      else
	@header[normalized_name] = [ value ]
      end

      nil
    end

    def delete_header(name, pos=nil)
      normalized_name = Message.normalize_header(name)
      if (pos) then
	if (value_list = @header[normalized_name]) then
	  del_val = value_list.delete_at(pos)
	  if (value_list.empty?) then
	    @header.delete(normalized_name)
	  end
	  return del_val
	end
      else
	return @header.delete(normalized_name)
      end

      nil
    end

    def delete_header_if(name)
      deleted = false
      normalized_name = Message.normalize_header(name)
      if (value_list = @header[normalized_name]) then
	value_list.delete_if{ |value|
	  if (yield(value)) then
	    deleted = true
	  end
	}
      end

      deleted ? self : nil
    end

    def has_header?(name)
      normalized_name = Message.normalize_header(name)
      @header.include? normalized_name
    end

    def each_header
      for name, value_list in @header.sort{ |a, b| a[0] <=> b[0] }
	for value in value_list
	  yield(name, value)
	end
      end

      nil
    end

    def parse_header(input)
      for line in input
	line.chomp!("\n")
	line.chomp!("\r")
	break if line.empty?

	name, value = line.split(/:/, 2)
	if (name.nil? || value.nil?) then
	  raise ParseError, "failed to parse a header field: #{line.inspect}"
	end

	name.strip!
	value.strip!
	set_header(name, value, true)
      end

      nil
    end
  end
end
