# $Id: error.rb,v 1.2 2004/04/07 00:29:03 toki Exp $

require 'rucy/status'

module Rucy
  class ParseError < StandardError
  end

  class HTTPError < StandardError
    def initialize(status=500, messg=nil)
      if (messg) then
	super(messg)
      elsif (HTTP_STAT.include? status) then
	super("#{status} #{HTTP_STAT[status]}")
      else
	super("#{status} Unknown")
      end
      @status = status
      @header = Hash.new
    end

    attr_reader :status

    def header(name)
      @header[name]
    end

    def set_header(name, value)
      @header[name] = value
    end

    def each_header
      for name, value in @header
	yield(name, value)
      end

      nil
    end
  end
end
