# $Id: cache.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

require 'thread'

module Rucy
  class ImmutableObjectCache
    def initialize(cache_limit=1000, &factory)
      @factory = factory
      @cache_map = Hash.new
      @cache_lock = Mutex.new
      @cache_limit = cache_limit
    end

    attr_reader :cache_limit

    def clear
      @cache_lock.synchronize{
	@cache_map.clear
      }
      nil
    end

    def fetch(*args)
      # Double checked locking algorithm.
      # This algorithm would not work well if ruby thread is native.
      unless (obj = @cache_map[args]) then
	@cache_lock.synchronize{
	  unless (obj = @cache_map[args]) then
	    obj = @factory.call(*args)
	    if (@cache_limit && @cache_map.size >= @cache_limit) then
	      # defence of cache overflow
	      @cache_map.clear
	    end
	    @cache_map[args] = obj
	  end
	}
      end

      obj
    end

    def new(*args)
      fetch(*args)
    end

    def [](*args)
      fetch(*args)
    end
  end
end
