# $Id: SetupFilter.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

class SetupFilter < WPM::PageContext
  def init_context
    @driver = driver
    @control = page_option(:control)
    @factory = page_option(:factory)
    @filter_list = @control.filters
    query_params = @driver.params
    @filter_pos = query_params['pos']
    @filter_type = query_params['filter']
    @default_path = query_params['path'] || nil
    if (mask_desc = query_params['mask']) then
      mask_type, mask_value = mask_desc.split(/:/, 2)
      @default_mask_type = mask_type || nil
      @default_mask = mask_value || nil
    else
      @default_mask_type = nil
      @default_mask = nil
    end
    @default_virtual_host = query_params['vhost'] || nil
  end

  def reload_query
    query = Hash.new
    query['filter'] = @filter_type if @filter_type
    query['pos'] = @filter_pos if @filter_pos
    query
  end

  attr_reader :default_path
  attr_reader :default_mask_type
  attr_reader :default_mask
  attr_reader :default_virtual_host

  def default_comment
    nil
  end

  def doc_args(filter_name)
    @factory.filter_args(filter_name)
  end

  def doc_pos
    @filter_pos
  end

  def doc_type
    @filter_type
  end

  def doc_tag
    'filter'
  end

  def doc_label
    'filter'
  end

  def path_tag
    'attach_path'
  end

  def path_label
    'attach path'
  end

  def mask_tag
    'attach_mask'
  end

  def mask_label
    'attach mask'
  end

  def modified_count
    @filter_list.modified_count
  end

  def modified_count=(modified_count)
    @filter_list.modified_count = modified_count
  end

  def document_list
    @filter_list
  end

  def write_document_list
    @control.set_filters(@filter_list)
    cancel
    nil
  end

  def cancel
    @driver.redirect('FilterMap')
    nil
  end
end
