# $Id: SetupDocument.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

class SetupDocument < WPM::PageContext
  def init_context
    @driver = driver
    @control = page_option(:control)
    @factory = page_option(:factory)
    @document_list = @control.documents
    query_params = @driver.params
    @doc_pos = query_params['pos']
    @doc_type = query_params['doc']
  end

  def reload_query
    query = Hash.new
    query['doc'] = @doc_type if @doc_type
    query['pos'] = @doc_pos if @doc_pos
    query
  end

  def default_path
    nil
  end

  def default_mask_type
    nil
  end

  def default_mask
    nil
  end

  def default_virtual_host
    nil
  end

  def default_comment
    nil
  end

  def doc_args(doc_name)
    @factory.doc_args(doc_name)
  end

  attr_reader :doc_pos
  attr_reader :doc_type

  def doc_tag
    'document'
  end

  def doc_label
    'document'
  end

  def path_tag
    'mount_path'
  end

  def path_label
    'mount path'
  end

  def mask_tag
    'mount_mask'
  end

  def mask_label
    'mount mask'
  end

  def modified_count
    @document_list.modified_count
  end

  def modified_count=(modified_count)
    @document_list.modified_count = modified_count
  end

  attr_reader :document_list

  def write_document_list
    @control.set_documents(@document_list)
    cancel
    nil
  end

  def cancel
    @driver.redirect('MountMap')
    nil
  end
end
