# $Id: SetupAlias.rb,v 1.2 2004/08/09 13:58:01 toki Exp $

class SetupAlias < WPM::PageContext
  include WPM::CheckUtil

  def init_context
    @driver = driver
    @control = page_option(:control)
    @alias_list = @control.aliases
    query_params = @driver.params
    if (query_params.include? 'pos') then
      self.position = query_params['pos']
    end
  end

  def modified_count
    @alias_list.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @alias_list.modified_count = modified_count.to_i
    modified_count
  end

  def position
    @pos.to_s
  end

  def position=(position)
    check_number(position) {|n| n >= 0 }
    @pos = position.to_i
    init_alias
    position
  end

  def alias_index
    @pos.succ.to_s
  end

  def reload_query
    { 'pos' => @pos.to_s }
  end

  def init_alias
    if (@pos < 0 || @alias_list.length < @pos) then
      raise 'out of range'
    end
    if (@pos == @alias_list.length) then
      @alias_list.push({ 'alias_path' => nil,
			 'orig_path' => nil,
			 'virtual_host' => nil
		       })
    end
    @alias = @alias_list[@pos]
    nil
  end
  private :init_alias

  def alias_path
    @alias['alias_path']
  end

  def alias_path=(alias_path)
    @alias['alias_path'] = alias_path
  end

  def orig_path
    @alias['orig_path']
  end

  def orig_path=(orig_path)
    @alias['orig_path'] = orig_path
  end

  def virtual_host
    @alias['virtual_host']
  end

  def virtual_host=(virtual_host)
    if (empty_string? virtual_host) then
      @alias['virtual_host'] = nil
    else
      @alias['virtual_host'] = virtual_host
    end
    virtual_host
  end

  def write
    check_not_empty(@alias['alias_path'])
    check_not_empty(@alias['orig_path'])
    @control.set_aliases(@alias_list)
    @driver.redirect('AliasMap')
    nil
  end

  def cancel
    @driver.redirect('AliasMap')
    nil
  end
end
