# $Id: Navigation.rb,v 1.3 2004/10/14 15:25:11 toki Exp $

class Navigation < WPM::PageContext
  include WPM::Escape

  def init_context
    @control = page_option(:control)
    @driver = driver
    @page = nil
    @query = Hash.new
  end

  def server_restart
    @driver.set_header('Connection', 'close')
    @control.server_restart
    nil
  end

  def server_close
    @driver.set_header('Connection', 'close')
    @control.server_close
    nil
  end

  attr_accessor :page
  attr_accessor :query

  def has_hidden_params?
    ! @query.empty?
  end

  def hidden_params
    params = ''
    for name, value in @query.sort
      params << '<input name="' << escapeHTML(name) << '"'
      params << ' type="hidden"'
      params << ' value="' << escapeHTML(value) << '"'
      params << ' />'
    end
    params
  end

  def control_panel?
    @page == 'ControlPanel'
  end

  def mount_map?
    @page == 'MountMap' || @page == 'SetupDocument'
  end

  def filter_map?
    @page == 'FilterMap' || @page == 'SetupFilter'
  end

  def alias_map?
    @page == 'AliasMap' || @page == 'SetupAlias'
  end

  def logging?
    @page == 'Logging' || @page == 'AddLogFile'
  end

  def access_log?
    @page == 'AccessLog' || @page == 'AddAccessLog'
  end

  def error?
    @page == 'Error'
  end

  def administrator?
    @page == 'Administrator' || @page == 'AdminPassword'
  end

  def about?
    @page == 'About'
  end
end
