# $Id: MountMap.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

class MountMap < WPM::PageContext
  include WPM::Escape

  def init_context
    @driver = driver
    @control = page_option(:control)
    @factory = page_option(:factory)
    @document_list = @control.documents
  end

  def modified_count
    @document_list.modified_count
  end

  def modified_count=(modified_count)
    @document_list.modified_count = modified_count
  end

  attr_reader :document_list

  def doc_args(doc_name)
    @factory.doc_args(doc_name)
  end

  def doc_names
    @factory.doc_names
  end

  def doc_tag
    'document'
  end

  def doc_label
    'document'
  end

  def path_tag
    'mount_path'
  end

  def path_label
    'mount path'
  end

  def mask_tag
    'mount_mask'
  end

  def mask_label
    'mount mask'
  end

  def write_document_list
    @control.set_documents(@document_list)
    nil
  end

  def setup_document(doc_type, pos)
    @driver.redirect('SetupDocument', { 'doc' => doc_type, 'pos' => pos.to_s })
    nil
  end
end
