# $Id: Logging.rb,v 1.2 2004/09/23 13:18:05 toki Exp $

require 'forwardable'

class Logging < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @logging_params = @control.logging_params
    @index = nil
    @call_index = nil
  end

  def_delegator(:@logging_params, :modified_count)
  def_delegator(:@logging_params, :modified_count=)
  def_delegator(:@logging_params, :stdout_logging_level)
  def_delegator(:@logging_params, :stdout_logging_level=)

  def has_logfiles?
    ! @logging_params.logfiles.empty?
  end
  
  def logfile_count
    @logging_params.logfiles.length
  end

  attr_accessor :index
  attr_writer :call_index

  def_delegator('@logging_params.logfiles[@call_index]', :path, :logfile_path)
  def_delegator('@logging_params.logfiles[@call_index]', :path=, :logfile_path=)
  def_delegator('@logging_params.logfiles[@call_index]', :logging_level, :logfile_logging_level)
  def_delegator('@logging_params.logfiles[@call_index]', :logging_level=, :logfile_logging_level=)

  def logfile_delete
    @logging_params.del_logfile_at(@call_index)
    write_logging_parameter
    nil
  end

  def write_logging_parameter
    @control.set_logging_params(@logging_params)
    nil
  end
end
