# $Id: FilterMap.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

class FilterMap < WPM::PageContext
  include WPM::Escape

  def init_context
    @driver = driver
    @control = page_option(:control)
    @factory = page_option(:factory)
    @filter_list = @control.filters
  end

  def modified_count
    @filter_list.modified_count
  end

  def modified_count=(modified_count)
    @filter_list.modified_count = modified_count
  end

  def document_list
    @filter_list
  end

  def doc_args(filter_name)
    @factory.filter_args(filter_name)
  end

  def doc_names
    @factory.filter_names
  end

  def doc_tag
    'filter'
  end

  def doc_label
    'filter'
  end

  def path_tag
    'attach_path'
  end

  def path_label
    'attach path'
  end

  def mask_tag
    'attach_mask'
  end

  def mask_label
    'attach mask'
  end

  def write_document_list
    @control.set_filters(@filter_list)
    nil
  end

  def setup_document(filter_type, pos)
    @driver.redirect('SetupFilter', { 'filter' => filter_type, 'pos' => pos.to_s })
    nil
  end
end
