# $Id: Error.rb,v 1.2 2004/10/02 11:24:03 toki Exp $

require 'forwardable'

class Error < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @factory = page_option(:factory)
    @load_error_list = @control.load_errors
    @lib_name = nil
    @load_error = nil
    @load_error_index = nil
    @document_error_list = @control.doc_errors
    @document_error = nil
    @doc_error_index = nil
    @doc_argument = nil
    @doc_arg_index = nil
    @filter_error_list = @control.filter_errors
    @filter_error = nil
    @filter_error_index = nil
    @filter_argument = nil
    @filter_arg_index = nil
    @alias_error_list = @control.alias_errors
    @alias_error = nil
    @logging_error_list = @control.logging_errors
    @logging_error = nil
    @log_error_index = nil
  end

  def has_load_errors?
    ! @load_error_list.empty?
  end

  attr_reader :load_error_list
  attr_accessor :load_error_index

  def load_error=(load_error)
    @lib_name, @load_error = load_error
  end

  attr_reader :lib_name

  def load_error_type
    @load_error.class.to_s
  end

  def load_error_msg
    @load_error.message
  end

  def has_document_errors?
    ! @document_error_list.empty?
  end

  attr_reader :document_error_list
  attr_writer :document_error
  attr_accessor :doc_error_index

  def doc_defined?
    @factory.has_document? @document_error[:document]
  end

  def doc_name
    @document_error[:document]
  end

  def doc_args
    arg_alist = Array.new
    doc_args = @factory.doc_args(doc_name)
    @document_error[:arguments].each_with_index do |arg, i|
      arg_alist.push([ doc_args[i][0], arg ])
    end
    arg_alist
  end

  def mount_path
    @document_error[:mount_path]
  end

  def mount_mask
    @document_error[:mount_mask]
  end

  def mount_virtual_host
    @document_error[:virtual_host]
  end

  def doc_error_type
    @document_error[:exception].class.to_s
  end

  def doc_error_msg
    @document_error[:exception].message
  end

  def has_doc_args?
    ! @document_error[:arguments].empty?
  end

  attr_writer :doc_argument
  attr_accessor :doc_arg_index

  def doc_arg_name
    @doc_argument[0]
  end

  def doc_arg_value
    @doc_argument[1]
  end

  def has_filter_errors?
    ! @filter_error_list.empty?
  end

  attr_reader :filter_error_list
  attr_writer :filter_error
  attr_accessor :filter_error_index

  def filter_defined?
    @factory.has_filter? @filter_error[:filter]
  end

  def filter_name
    @filter_error[:filter]
  end

  def filter_args
    arg_alist = Array.new
    filter_args = @factory.filter_args(filter_name)
    @filter_error[:arguments].each_with_index do |arg, i|
      arg_alist.push([ filter_args[i][0], arg ])
    end
    arg_alist
  end

  def attach_path
    @filter_error[:attach_path]
  end

  def attach_mask
    @filter_error[:attach_mask]
  end

  def attach_virtual_host
    @filter_error[:virtual_host]
  end

  def filter_error_type
    @filter_error[:exception].class.to_s
  end

  def filter_error_msg
    @filter_error[:exception].message
  end

  def has_filter_args?
    ! @filter_error[:arguments].empty?
  end

  attr_writer :filter_argument
  attr_accessor :filter_arg_index

  def filter_arg_name
    @filter_argument[0]
  end

  def filter_arg_value
    @filter_argument[1]
  end

  def has_alias_errors?
    ! @alias_error_list.empty?
  end

  attr_reader :alias_error_list
  attr_writer :alias_error

  def alias_path
    @alias_error[:alias_path]
  end

  def alias_orig_path
    @alias_error[:orig_path]
  end

  def alias_virtual_host
    @alias_error[:virtual_host]
  end

  def alias_error_type
    @alias_error[:exception].class.to_s
  end

  def alias_error_msg
    @alias_error[:exception].message
  end

  def has_logging_errors?
    ! @logging_error_list.empty?
  end

  attr_reader :logging_error_list
  attr_writer :logging_error
  attr_accessor :log_error_index

  def log_file
    @logging_error[:logfile]
  end

  def log_error_type
    @logging_error[:exception].class.to_s
  end

  def log_error_msg
    @logging_error[:exception].message
  end
end
