# $Id: EditProperties.rb,v 1.2 2004/04/21 15:09:26 toki Exp $

class EditProperties < WPM::PageContext
  def init_context
    @src = nil
    @pw_enc = page_option(:pw_enc)
  end

  def properties_source=(properties_source)
    @src = properties_source
    self.document_position = @src.doc_pos
    self.document_type = @src.doc_type
    properties_source
  end

  def doc_label
    @src.doc_label
  end

  def path_label
    @src.path_label
  end

  def mask_label
    @src.mask_label
  end

  def modified_count
    @src.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) { |n| n >= 0 }
    @src.modified_count = modified_count.to_i
    modified_count
  end

  def document_position
    @doc_pos.to_s
  end

  def document_position=(new_pos)
    if (! (empty_string? new_pos)) then
      @doc_pos = new_pos.to_i
    else
      @doc_pos = 0
    end
    init_mount_params
    new_pos
  end

  def document_type
    @doc_type
  end

  def document_type=(new_type)
    if (new_type) then
      @doc_type = new_type
      init_doc_args
    end
    new_type
  end

  def doc_index
    @doc_pos.succ.to_s
  end

  def init_mount_params
    document_list = @src.document_list
    if (@doc_pos < document_list.length) then
      @doc_path = document_list[@doc_pos][@src.path_tag]
      case (doc_mask = document_list[@doc_pos][@src.mask_tag])
      when NilClass
	@doc_mask = nil
	@doc_mask_type_selected = 'nil'
      when Regexp
	@doc_mask = doc_mask.source.dup
	@doc_mask.sub!(%r"\(", '')
	@doc_mask.sub!(%r"\)\(\\?/\|\$\)", '')
	@doc_mask_type_selected = 'regexp'
      when ::String
	@doc_mask = doc_mask
	@doc_mask_type_selected = 'string'
      else
	raise "unknown mask type: #{doc_mask.inspect} (#{doc_mask.class})"
      end
      @virtual_host = document_list[@doc_pos]['virtual_host']
      @comment = document_list[@doc_pos]['comment']
    else
      @doc_path = @src.default_path
      if (default_mask_type = @src.default_mask_type) then
	case (default_mask_type)
	when 'nil'
	  @doc_mask = nil
	  @doc_mask_type_selected = 'nil'
	when 'regexp'
	  @doc_mask = @src.default_mask
	  @doc_mask_type_selected = 'regexp'
	when 'string'
	  @doc_mask = @src.default_mask
	  @doc_mask_type_selected = 'string'
	else
	  raise "unknown mask type: #{default_mask_type.inspect}"
	end
      else
	@doc_mask = nil
	@doc_mask_type_selected = 'nil'
      end
      @virtual_host = @src.default_virtual_host
      @comment = @src.default_comment
    end
    nil
  end
  private :init_mount_params

  attr_reader :doc_path
  attr_accessor :doc_mask
  attr_accessor :doc_mask_type_selected
  attr_accessor :virtual_host
  attr_accessor :comment

  def doc_path=(doc_path)
    @doc_path = doc_path
  end

  def init_doc_args
    @argument = nil
    @arg_index = nil
    @doc_args = Array.new
    @arg_pos_map = Hash.new
    @call_index_map = Hash.new
    @arg_checked_alist = Array.new
    @arg_check_call_index = nil
    @arg_radio_alist = Array.new
    @arg_radio_item_call_index = nil

    arg_alist = @src.doc_args(@doc_type)
    document_list = @src.document_list
    radio_count = 0
    if (@doc_pos < document_list.length && @doc_type == document_list[@doc_pos][@src.doc_tag]) then
      arg_values = document_list[@doc_pos]['arguments']
      arg_alist.each_with_index do |(arg_name, arg_type, arg_default), i|
	arg_info = {
	  :name => arg_name,
	  :type => arg_type,
	  :default => arg_default,
	  :clear => false
	}
	case (arg_type)
	when :checkset
	  arg_info[:value] = arg_values[i]
	  for check_name, checked in arg_default
	    @arg_checked_alist.push([ check_name, arg_info ])
	  end
	when :radio
	  arg_info[:value] = arg_values[i]
	  radio_name = "RadioGroup#{radio_count}"
	  for radio_value in arg_default
	    @arg_radio_alist.push([ radio_name, radio_value, arg_info ])
	  end
	  radio_count += 1
	else
	  arg_info[:value] = arg_values[i]
	end
	@doc_args.push(arg_info)
      end
    else
      arg_alist.each_with_index do |(arg_name, arg_type, arg_default), i|
	arg_info = {
	  :name => arg_name,
	  :type => arg_type,
	  :default => arg_default
	}
	case (arg_type)
	when :select
	  arg_info[:value] = arg_default[0]
	when :checkset
	  arg_checkset = Hash.new
	  arg_info[:value] = arg_checkset
	  for check_name, checked in arg_default
	    arg_checkset[check_name] = checked
	    @arg_checked_alist.push([ check_name, arg_info ])
	  end
	when :radio
	  arg_info[:value] = arg_default[0]
	  radio_name = "RadioGroup#{radio_count}"
	  for radio_value in arg_default
	    @arg_radio_alist.push([ radio_name, radio_value, arg_info ])
	  end
	  radio_count += 1
	else
	  arg_info[:value] = arg_default
	end
	@doc_args.push(arg_info)
      end
    end

    @doc_args.each_with_index do |arg_info, i|
      arg_type = arg_info[:type]
      @arg_pos_map[arg_type] = Array.new unless (@arg_pos_map.include? arg_type)
      @arg_pos_map[arg_type].push(i)
    end

    nil
  end
  private :init_doc_args

  attr_reader :doc_args
  attr_writer :argument
  attr_accessor :arg_index

  def arg_name
    @argument[:name]
  end

  def arg_pos(arg_type)
    call_index = @call_index_map[arg_type]
    @arg_pos_map[arg_type][call_index]
  end
  private :arg_pos

  def arg_type_string?
    @argument[:type] == :string
  end

  def arg_string_call_index=(index)
    @call_index_map[:string] = index
  end

  def arg_string_value
    pos = arg_pos(:string)
    @doc_args[pos][:value]
  end

  def arg_string_value=(string_value)
    pos = arg_pos(:string)
    @doc_args[pos][:value] = string_value
  end

  def arg_type_password?
    @argument[:type] == :password
  end

  def arg_password_call_index=(index)
    @call_index_map[:password] = index
  end

  def arg_password_value
    pos = arg_pos(:password)
    @doc_args[pos][:value]
  end

  def arg_password_value=(password_value)
    pos = arg_pos(:password)
    unless (empty_string? password_value) then
      @doc_args[pos][:value] = @pw_enc.crypt(password_value)
    end
    password_value
  end

  def arg_password_cleared
    pos = arg_pos(:password)
    @doc_args[pos][:clear]
  end

  def arg_password_cleared=(pw_clear)
    pos = arg_pos(:password)
    @doc_args[pos][:clear] = pw_clear
  end

  def arg_type_text?
    @argument[:type] == :text
  end

  def arg_text_call_index=(index)
    @call_index_map[:text] = index
  end

  def arg_text_value
    pos = arg_pos(:text)
    @doc_args[pos][:value]
  end

  def arg_text_value=(text_value)
    pos = arg_pos(:text)
    @doc_args[pos][:value] = text_value
  end

  def arg_type_number?
    @argument[:type] == :number
  end

  def arg_num_call_index=(index)
    @call_index_map[:number] = index
  end

  def arg_num_value
    pos = arg_pos(:number)
    @doc_args[pos][:value] && @doc_args[pos][:value].to_s
  end

  def arg_num_value=(num_value)
    pos = arg_pos(:number)
    if (! (empty_string? num_value)) then
      check_number(num_value)
      @doc_args[pos][:value] = num_value.to_i
    else
      @doc_args[pos][:value] = nil
    end
    num_value
  end

  def arg_type_regexp?
    @argument[:type] == :regexp
  end

  def arg_regexp_call_index=(index)
    @call_index_map[:regexp] = index
  end

  def arg_regexp_value
    pos = arg_pos(:regexp)
    @doc_args[pos][:value] && @doc_args[pos][:value].source
  end

  def arg_regexp_value=(regexp_value)
    pos = arg_pos(:regexp)
    if (! (empty_string? regexp_value)) then
      @doc_args[pos][:value] = Regexp.compile(regexp_value)
    else
      @doc_args[pos][:value] = nil
    end
    regexp_value
  end

  def arg_type_bool?
    @argument[:type] == :bool
  end

  def arg_bool_call_index=(index)
    @call_index_map[:bool] = index
  end

  def arg_bool_value
    pos = arg_pos(:bool)
    @doc_args[pos][:value]
  end

  def arg_bool_value=(bool_value)
    pos = arg_pos(:bool)
    @doc_args[pos][:value] = bool_value
  end

  def arg_type_select?
    @argument[:type] == :select
  end

  def arg_select_call_index=(index)
    @call_index_map[:select] = index
  end

  def arg_select_list
    pos = arg_pos(:select)
    @doc_args[pos][:default]
  end

  def arg_select_value
    pos = arg_pos(:select)
    @doc_args[pos][:value]
  end

  def arg_select_value=(select_value)
    pos = arg_pos(:select)
    @doc_args[pos][:value] = select_value
  end

  def arg_type_checkset?
    @argument[:type] == :checkset
  end

  def arg_checkset_call_index=(index)
    @call_index_map[:checkset] = index
  end

  def arg_checkset_count
    pos = arg_pos(:checkset)
    @doc_args[pos][:default].length
  end

  attr_writer :arg_check_call_index

  def arg_check_name
    @arg_checked_alist[@arg_check_call_index][0]
  end

  def arg_checked
    check_name, arg_info = @arg_checked_alist[@arg_check_call_index]
    arg_checkset = arg_info[:value]
    arg_checkset[check_name]
  end

  def arg_checked=(checked)
    check_name, arg_info = @arg_checked_alist[@arg_check_call_index]
    arg_checkset = arg_info[:value]
    arg_checkset[check_name] = checked
  end

  def arg_type_radio?
    @argument[:type] == :radio
  end

  def arg_radio_call_index=(index)
    @call_index_map[:radio] = index
  end

  def arg_radio_count
    pos = arg_pos(:radio)
    @doc_args[pos][:default].length
  end

  attr_writer :arg_radio_item_call_index

  def arg_radio_name
    @arg_radio_alist[@arg_radio_item_call_index][0]
  end

  def arg_radio_value
    @arg_radio_alist[@arg_radio_item_call_index][1]
  end

  def arg_radio_selected
    @arg_radio_alist[@arg_radio_item_call_index][2][:value]
  end

  def arg_radio_selected=(selected)
    @arg_radio_alist[@arg_radio_item_call_index][2][:value] = selected
  end

  def write_properties
    if (empty_string? doc_path) then
      raise "not allowed a empty #{@src.path_label}."
    end
    document_list = @src.document_list
    document_list[@doc_pos] = Hash.new if (@doc_pos >= document_list.length)
    document_list[@doc_pos][@src.doc_tag] = @doc_type
    document_list[@doc_pos][@src.path_tag] = @doc_path
    case (@doc_mask_type_selected)
    when 'nil'
      document_list[@doc_pos][@src.mask_tag] = nil
    when 'regexp'
      document_list[@doc_pos][@src.mask_tag] = Regexp.compile("(#{@doc_mask})(/|$)")
    when 'string'
      document_list[@doc_pos][@src.mask_tag] = @doc_mask || ''
    else
      raise "unknown mask selection: #{@doc_mask_type_selected.inspect}"
    end
    if (! (empty_string? @virtual_host, true)) then
      if (@virtual_host =~ /:\d+$/) then
	raise "no use of port number: #{@virtual_host.inspect}"
      end
      document_list[@doc_pos]['virtual_host'] = @virtual_host
    else
      document_list[@doc_pos]['virtual_host'] = nil
    end
    document_list[@doc_pos]['comment'] = @comment
    document_list[@doc_pos]['arguments'] = @doc_args.map{ |arg_info|
      (arg_info[:clear]) ? nil : arg_info[:value]
    }
    @src.write_document_list
    nil
  end

  def cancel
    @src.cancel
    nil
  end
end
