# $Id: ControlPanel.rb,v 1.6 2004/10/17 15:08:29 toki Exp $

require 'forwardable'

class ControlPanel < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @server_params = @control.server_params
  end

  def_delegator :@server_params, :modified_count
  def_delegator :@server_params, :modified_count=
  def_delegator :@server_params, :server_type
  def_delegator :@server_params, :server_type=
  def_delegator :@server_params, :port
  def_delegator :@server_params, :port=
  def_delegator :@server_params, :bind_address
  def_delegator :@server_params, :bind_address=
  def_delegator :@server_params, :timeout
  def_delegator :@server_params, :timeout=
  def_delegator :@server_params, :keep_alive
  def_delegator :@server_params, :keep_alive=
  def_delegator :@server_params, :max_requests
  def_delegator :@server_params, :max_requests=
  def_delegator :@server_params, :queue_length
  def_delegator :@server_params, :queue_length=
  def_delegator :@server_params, :messengers
  def_delegator :@server_params, :messengers=
  def_delegator :@server_params, :messenger_threads
  def_delegator :@server_params, :messenger_threads=
  def_delegator :@server_params, :messenger_queue_length
  def_delegator :@server_params, :messenger_queue_length=
  def_delegator :@server_params, :do_not_reverse_lookup
  def_delegator :@server_params, :do_not_reverse_lookup=

  def subprocess_user
    @server_params.subprocess_user.to_s
  end

  def subprocess_user=(new_user)
    new_user = new_user.strip
    if (new_user =~ /^\d+$/) then
      @server_params.subprocess_user = new_user.to_i
    else
      @server_params.subprocess_user = new_user
    end
  end

  def subprocess_group
    @server_params.subprocess_group.to_s
  end

  def subprocess_group=(new_group)
    new_group = new_group.strip
    if (new_group =~ /^\d+$/) then
      @server_params.subprocess_group = new_group.to_i
    else
      @server_params.subprocess_group = new_group
    end
  end

  def write_server_params
    @control.set_server_params(@server_params)
    nil
  end
end
